/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.blockstorage.entities;

import com.eucalyptus.blockstorage.Storage;
import com.eucalyptus.blockstorage.entities.VolumeInfo;
import com.eucalyptus.blockstorage.util.StorageProperties;
import com.eucalyptus.entities.AbstractPersistent;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.upgrade.Upgrades;
import com.eucalyptus.util.EucalyptusCloudException;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.walrus.entities.WalrusSnapshotInfo;
import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityTransaction;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_storage")
@Table(name="Snapshots")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class SnapshotInfo
extends AbstractPersistent {
    private static final String AUTHORITY = "snapshots";
    @Column(name="snapshot_user_name")
    private String userName;
    @Column(name="sc_name")
    private String scName = StorageProperties.NAME;
    @Column(name="snapshot_name")
    String snapshotId;
    @Column(name="volume_name")
    String volumeId;
    @Column(name="status")
    String status;
    @Column(name="start_time")
    Date startTime;
    @Column(name="progress")
    private String progress;
    @Column(name="should_transfer")
    private Boolean shouldTransfer;
    @Column(name="snapshot_point_id")
    private String snapPointId;
    @Column(name="snapshot_size_gb")
    private Integer sizeGb;
    @Column(name="snapshot_location")
    private String snapshotLocation;

    public SnapshotInfo() {
    }

    public SnapshotInfo(String snapshotId) {
        this();
        this.snapshotId = snapshotId;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getScName() {
        return this.scName;
    }

    public void setScName(String scName) {
        this.scName = scName;
    }

    public String getSnapshotId() {
        return this.snapshotId;
    }

    public void setSnapshotId(String snapshotId) {
        this.snapshotId = snapshotId;
    }

    public String getVolumeId() {
        return this.volumeId;
    }

    public void setVolumeId(String volumeId) {
        this.volumeId = volumeId;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public String getProgress() {
        return this.progress;
    }

    public void setProgress(String progress) {
        this.progress = progress;
    }

    public Boolean getShouldTransfer() {
        return this.shouldTransfer;
    }

    public void setShouldTransfer(Boolean shouldTransfer) {
        this.shouldTransfer = shouldTransfer;
    }

    public String getSnapPointId() {
        return this.snapPointId;
    }

    public void setSnapPointId(String snapPointId) {
        this.snapPointId = snapPointId;
    }

    public Integer getSizeGb() {
        return this.sizeGb;
    }

    public void setSizeGb(Integer snapSizeGb) {
        this.sizeGb = snapSizeGb;
    }

    public String getSnapshotLocation() {
        return this.snapshotLocation;
    }

    public void setSnapshotLocation(String snapshotLocation) {
        this.snapshotLocation = snapshotLocation;
    }

    public static String generateSnapshotLocationURI(String server, String bucket, String key) throws URISyntaxException, EucalyptusCloudException {
        if (StringUtils.isNotBlank((String)bucket) && StringUtils.isNotBlank((String)key)) {
            URI snapshotUri = new URI(AUTHORITY, server, '/' + bucket + '/' + key, null, null);
            return snapshotUri.toString();
        }
        throw new EucalyptusCloudException("Invalid bucket and or key names. Bucket: " + bucket + ", Key: " + key);
    }

    public static String[] getSnapshotBucketKeyNames(String snapshotUriString) throws URISyntaxException, EucalyptusCloudException {
        if (StringUtils.isNotBlank((String)snapshotUriString)) {
            URI snapshotUri = new URI(snapshotUriString);
            String[] parts = snapshotUri.getPath().split("/");
            if (parts.length >= 3) {
                if (StringUtils.isBlank((String)parts[0]) && StringUtils.isNotBlank((String)parts[1]) && StringUtils.isNotBlank((String)parts[2])) {
                    return new String[]{parts[1], parts[2]};
                }
                throw new EucalyptusCloudException("Bucket and or key name not found in snapshot location: " + snapshotUriString);
            }
            throw new EucalyptusCloudException("Failed to parse bucket and key names from snapshot location: " + snapshotUriString);
        }
        throw new EucalyptusCloudException("Invalid snapshot location: " + snapshotUriString);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.scName == null ? 0 : this.scName.hashCode());
        result = 31 * result + (this.snapshotId == null ? 0 : this.snapshotId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        SnapshotInfo other = (SnapshotInfo)((Object)obj);
        if (this.scName == null ? other.scName != null : !this.scName.equals(other.scName)) {
            return false;
        }
        return !(this.snapshotId == null ? other.snapshotId != null : !this.snapshotId.equals(other.snapshotId));
    }

    @Upgrades.EntityUpgrade(entities={SnapshotInfo.class}, since=Upgrades.Version.v4_0_0, value=Storage.class)
    public static enum SnapshotEntity400Upgrade implements Predicate<Class>
    {
        INSTANCE;

        private static Logger LOG;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean apply(@Nullable Class arg0) {
            EntityTransaction db;
            block17: {
                HashMap snapIDSizeMap;
                HashMap snapIDBucketNameMap;
                List snaps;
                db = Entities.get(SnapshotInfo.class);
                try {
                    SnapshotInfo example = new SnapshotInfo();
                    example.setScName(null);
                    snaps = Entities.query((Object)((Object)example));
                    if (!(snaps != null & !snaps.isEmpty())) break block17;
                    snapIDBucketNameMap = Maps.newHashMap();
                    snapIDSizeMap = Maps.newHashMap();
                    EntityTransaction walrusSnapshotsdb = Entities.get(WalrusSnapshotInfo.class);
                    try {
                        List walrusSnapshots = Entities.query((Object)new WalrusSnapshotInfo(), (boolean)Boolean.TRUE);
                        for (WalrusSnapshotInfo walrusSnapshot : walrusSnapshots) {
                            snapIDBucketNameMap.put(walrusSnapshot.getSnapshotId(), walrusSnapshot.getNaturalId());
                            snapIDSizeMap.put(walrusSnapshot.getSnapshotId(), walrusSnapshot.getSize());
                        }
                    }
                    catch (Exception e) {
                        walrusSnapshotsdb.rollback();
                        boolean i$ = false;
                        if (db.isActive()) {
                            db.commit();
                        }
                        return i$;
                    }
                    finally {
                        if (walrusSnapshotsdb.isActive()) {
                            walrusSnapshotsdb.commit();
                        }
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)"Failed to upgrade location/size during SnapshotInfo entity upgrade", (Throwable)e);
                    db.rollback();
                    boolean bl = false;
                    return bl;
                }
                finally {
                    if (db.isActive()) {
                        db.commit();
                    }
                }
                for (SnapshotInfo snap : snaps) {
                    String snapId = snap.getSnapshotId();
                    if (!snapIDBucketNameMap.containsKey(snapId)) continue;
                    if (snap.getSnapshotLocation() == null) {
                        snap.setSnapshotLocation(SnapshotInfo.generateSnapshotLocationURI("objectstoragegateway", (String)snapIDBucketNameMap.get(snapId), snapId));
                    }
                    if (snap.getSizeGb() != null) continue;
                    snap.setSizeGb((Integer)snapIDSizeMap.get(snapId));
                }
            }
            db.commit();
            return true;
        }

        static {
            LOG = Logger.getLogger(SnapshotEntity400Upgrade.class);
        }
    }

    @Upgrades.EntityUpgrade(entities={SnapshotInfo.class}, since=Upgrades.Version.v3_4_0, value=Storage.class)
    public static enum SnapshotEntityUpgrade implements Predicate<Class>
    {
        INSTANCE;

        private static Logger LOG;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean apply(@Nullable Class aClass) {
            EntityTransaction db = Entities.get(SnapshotInfo.class);
            try {
                SnapshotInfo example = new SnapshotInfo();
                List snaps = Entities.query((Object)((Object)example));
                if (snaps != null && snaps.size() > 0) {
                    for (SnapshotInfo snapshot : snaps) {
                        if (snapshot.getSizeGb() != null) continue;
                        EntityTransaction volDb = Entities.get(VolumeInfo.class);
                        try {
                            VolumeInfo vol = (VolumeInfo)((Object)Entities.uniqueResult((Object)((Object)new VolumeInfo(snapshot.getVolumeId()))));
                            if (vol != null) {
                                snapshot.setSizeGb(vol.getSize());
                                LOG.debug((Object)("Setting snapshot size on entity: " + snapshot.getScName() + snapshot.getSnapshotId() + " to : " + snapshot.getSizeGb()));
                                db.commit();
                                continue;
                            }
                            LOG.debug((Object)("No volume record found for snapshot " + snapshot.getScName() + ", " + snapshot.getSnapshotId() + " will have size set on upgrade of the backend snapshot entity"));
                        }
                        finally {
                            volDb.rollback();
                            volDb = null;
                        }
                    }
                }
                db.commit();
            }
            catch (Exception ex) {
                LOG.error((Object)"caught exception during upgrade, while attempting to set snapshot size");
                throw Exceptions.toUndeclared((Throwable)ex);
            }
            finally {
                db.rollback();
            }
            return true;
        }

        static {
            LOG = Logger.getLogger(SnapshotEntityUpgrade.class);
        }
    }
}

