/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.blockstorage.entities;

import com.eucalyptus.blockstorage.Storage;
import com.eucalyptus.blockstorage.util.StorageProperties;
import com.eucalyptus.entities.AbstractPersistent;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.upgrade.Upgrades;
import com.eucalyptus.util.Exceptions;
import com.google.common.base.Predicate;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.EntityTransaction;
import javax.persistence.MappedSuperclass;
import javax.persistence.PersistenceContext;
import org.apache.log4j.Logger;

@PersistenceContext(name="eucalyptus_storage")
@MappedSuperclass
public class LVMVolumeInfo
extends AbstractPersistent {
    @Column(name="volume_name")
    protected String volumeId;
    @Column(name="sc_name")
    private String scName = StorageProperties.NAME;
    @Column(name="lodev_name")
    private String loDevName;
    @Column(name="lofile_name")
    private String loFileName;
    @Column(name="pv_name")
    private String pvName;
    @Column(name="vg_name")
    private String vgName;
    @Column(name="lv_name")
    private String lvName;
    @Column(name="size")
    protected Integer size;
    @Column(name="status")
    private String status;
    @Column(name="snapshot_of")
    private String snapshotOf;
    @Column(name="cleanup")
    private Boolean cleanup;
    public static final String LVM_ROOT_DIRECTORY = "/dev";
    public static final String PATH_SEPARATOR = "/";

    public String getAbsoluteLVPath() {
        if (this.getVgName() != null && this.getLvName() != null) {
            return "/dev/" + this.getVgName() + PATH_SEPARATOR + this.getLvName();
        }
        return null;
    }

    public String toString() {
        return this.volumeId + "," + this.scName + "," + this.loDevName + "," + this.loFileName + "," + this.pvName + "," + this.vgName + "," + this.lvName + "," + this.size + "," + this.status + "," + this.snapshotOf + "," + this.cleanup;
    }

    public LVMVolumeInfo() {
    }

    public LVMVolumeInfo(String volumeId) {
        this();
        this.volumeId = volumeId;
    }

    public String getVolumeId() {
        return this.volumeId;
    }

    public void setVolumeId(String volumeId) {
        this.volumeId = volumeId;
    }

    public String getScName() {
        return this.scName;
    }

    public void setScName(String scName) {
        this.scName = scName;
    }

    public String getLoDevName() {
        return this.loDevName;
    }

    public void setLoDevName(String loDevName) {
        this.loDevName = loDevName;
    }

    public String getLoFileName() {
        return this.loFileName;
    }

    public void setLoFileName(String loFileName) {
        this.loFileName = loFileName;
    }

    public String getPvName() {
        return this.pvName;
    }

    public void setPvName(String pvName) {
        this.pvName = pvName;
    }

    public String getVgName() {
        return this.vgName;
    }

    public void setVgName(String vgName) {
        this.vgName = vgName;
    }

    public String getLvName() {
        return this.lvName;
    }

    public void setLvName(String lvName) {
        this.lvName = lvName;
    }

    public Integer getSize() {
        return this.size;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getSnapshotOf() {
        return this.snapshotOf;
    }

    public void setSnapshotOf(String snapshotOf) {
        this.snapshotOf = snapshotOf;
    }

    public Boolean getCleanup() {
        return this.cleanup == null ? false : this.cleanup;
    }

    public void setCleanup(Boolean cleanup) {
        this.cleanup = cleanup;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.scName == null ? 0 : this.scName.hashCode());
        result = 31 * result + (this.volumeId == null ? 0 : this.volumeId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        LVMVolumeInfo other = (LVMVolumeInfo)((Object)obj);
        if (this.scName == null ? other.scName != null : !this.scName.equals(other.scName)) {
            return false;
        }
        return !(this.volumeId == null ? other.volumeId != null : !this.volumeId.equals(other.volumeId));
    }

    @Upgrades.EntityUpgrade(entities={LVMVolumeInfo.class}, since=Upgrades.Version.v3_2_0, value=Storage.class)
    public static enum LVMVolumeInfoUpgrade implements Predicate<Class>
    {
        INSTANCE;

        private static Logger LOG;

        public boolean apply(Class arg0) {
            EntityTransaction db = Entities.get(LVMVolumeInfo.class);
            try {
                List entities = Entities.query((Object)((Object)new LVMVolumeInfo()));
                for (LVMVolumeInfo entry : entities) {
                    LOG.debug((Object)("Upgrading: " + entry.getVolumeId()));
                    entry.setCleanup(false);
                }
                db.commit();
                return true;
            }
            catch (Exception ex) {
                db.rollback();
                throw Exceptions.toUndeclared((Throwable)ex);
            }
        }

        static {
            LOG = Logger.getLogger(LVMVolumeInfoUpgrade.class);
        }
    }
}

