/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.blockstorage.entities;

import com.eucalyptus.blockstorage.Storage;
import com.eucalyptus.blockstorage.entities.LVMVolumeInfo;
import com.eucalyptus.blockstorage.entities.SnapshotInfo;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.upgrade.Upgrades;
import com.eucalyptus.util.Exceptions;
import com.google.common.base.Predicate;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityTransaction;
import javax.persistence.Lob;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Type;

@PersistenceContext(name="eucalyptus_storage")
@Table(name="ISCSIVolumeInfo")
@Entity
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class ISCSIVolumeInfo
extends LVMVolumeInfo {
    @Column(name="storename")
    private String storeName;
    @Column(name="tid")
    private Integer tid;
    @Column(name="lun")
    private Integer lun;
    @Column(name="storeuser")
    private String storeUser;
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    private String encryptedPassword;

    @Override
    public String toString() {
        return this.storeName + "," + this.tid + "," + this.lun + "," + this.storeUser + "," + super.toString();
    }

    public ISCSIVolumeInfo() {
    }

    public ISCSIVolumeInfo(String volumeId) {
        this.volumeId = volumeId;
    }

    public String getStoreName() {
        return this.storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }

    public Integer getTid() {
        return this.tid == null ? -1 : this.tid;
    }

    public void setTid(Integer tid) {
        this.tid = tid;
    }

    public Integer getLun() {
        return this.lun;
    }

    public void setLun(Integer lun) {
        this.lun = lun;
    }

    public String getStoreUser() {
        return this.storeUser;
    }

    public void setStoreUser(String storeUser) {
        this.storeUser = storeUser;
    }

    public String getEncryptedPassword() {
        return this.encryptedPassword;
    }

    public void setEncryptedPassword(String encryptedPassword) {
        this.encryptedPassword = encryptedPassword;
    }

    @Upgrades.EntityUpgrade(entities={ISCSIVolumeInfo.class}, since=Upgrades.Version.v3_4_0, value=Storage.class)
    public static enum ISCSIVolumeInfoSnapshotSizeUpgrade3_4 implements Predicate<Class>
    {
        INSTANCE;

        private static Logger LOG;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean apply(Class arg0) {
            EntityTransaction db = Entities.get(ISCSIVolumeInfo.class);
            try {
                ISCSIVolumeInfo example = new ISCSIVolumeInfo();
                example.setScName(null);
                List entities = Entities.query((Object)((Object)example));
                for (ISCSIVolumeInfo entry : entities) {
                    if (entry.getVolumeId().startsWith("snap-")) {
                        EntityTransaction snapDb = Entities.get(SnapshotInfo.class);
                        try {
                            SnapshotInfo exampleSnap = new SnapshotInfo(entry.getVolumeId());
                            exampleSnap.setScName(null);
                            List snaps = Entities.query((Object)((Object)exampleSnap));
                            for (SnapshotInfo snap : snaps) {
                                if (snap.getSizeGb() != null) continue;
                                snap.setSizeGb(entry.getSize());
                                LOG.debug((Object)("Upgrading: " + entry.getVolumeId() + " putting size from back-end to SnapshotInfo. Setting size to " + snap.getSizeGb()));
                            }
                            snapDb.commit();
                            continue;
                        }
                        finally {
                            snapDb.rollback();
                            snapDb = null;
                            continue;
                        }
                    }
                    LOG.debug((Object)("Skipping snapshot upgrade of " + entry.getVolumeId() + " because not a snapshot"));
                }
                db.commit();
                return true;
            }
            catch (Exception ex) {
                db.rollback();
                throw Exceptions.toUndeclared((Throwable)ex);
            }
        }

        static {
            LOG = Logger.getLogger(ISCSIVolumeInfoSnapshotSizeUpgrade3_4.class);
        }
    }
}

