/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.blockstorage.entities;

import com.eucalyptus.blockstorage.Storage;
import com.eucalyptus.blockstorage.util.StorageProperties;
import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableField;
import com.eucalyptus.configurable.ConfigurableFieldType;
import com.eucalyptus.configurable.ConfigurableIdentifier;
import com.eucalyptus.entities.AbstractPersistent;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.entities.Transactions;
import com.eucalyptus.upgrade.Upgrades;
import com.eucalyptus.util.Exceptions;
import com.google.common.base.Predicate;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.PersistenceContext;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_storage")
@Table(name="direct_storage_info")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
@ConfigurableClass(root="storage", alias="direct", description="Basic storage controller configuration.", singleton=false, deferred=true)
public class DirectStorageInfo
extends AbstractPersistent {
    private static Logger LOG = Logger.getLogger(DirectStorageInfo.class);
    @ConfigurableIdentifier
    @Column(name="storage_name", unique=true)
    private String name;
    @ConfigurableField(description="Storage volumes directory.", displayName="Volumes path")
    @Column(name="system_storage_volumes_dir")
    private String volumesDir;
    @ConfigurableField(description="Should volumes be zero filled.", displayName="Zero-fill volumes", type=ConfigurableFieldType.BOOLEAN)
    @Column(name="zero_fill_volumes")
    private Boolean zeroFillVolumes;
    @ConfigurableField(description="Timeout value in milli seconds for storage operations", displayName="Timeout in milli seconds")
    @Column(name="timeout_in_millis")
    private Long timeoutInMillis;

    public DirectStorageInfo() {
        this.name = StorageProperties.NAME;
    }

    public DirectStorageInfo(String name) {
        this.name = name;
    }

    public DirectStorageInfo(String name, String storageInterface, String volumesDir, Boolean zeroFillVolumes, Long timeoutInMillis) {
        this.name = name;
        this.volumesDir = volumesDir;
        this.zeroFillVolumes = zeroFillVolumes;
        this.timeoutInMillis = timeoutInMillis;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVolumesDir() {
        return this.volumesDir;
    }

    public void setVolumesDir(String volumesDir) {
        this.volumesDir = volumesDir;
    }

    public Boolean getZeroFillVolumes() {
        return this.zeroFillVolumes;
    }

    public void setZeroFillVolumes(Boolean zeroFillVolumes) {
        this.zeroFillVolumes = zeroFillVolumes;
    }

    public Long getTimeoutInMillis() {
        return this.timeoutInMillis;
    }

    public void setTimeoutInMillis(Long timeoutInMillis) {
        this.timeoutInMillis = timeoutInMillis;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        DirectStorageInfo other = (DirectStorageInfo)((Object)obj);
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public String toString() {
        return this.name;
    }

    @PreUpdate
    public void preUpdateChecks() {
        if (null == this.getTimeoutInMillis()) {
            this.setTimeoutInMillis(10000L);
        }
    }

    public static DirectStorageInfo getStorageInfo() {
        DirectStorageInfo conf = null;
        try {
            conf = (DirectStorageInfo)((Object)Transactions.find((Object)((Object)new DirectStorageInfo())));
        }
        catch (Exception e) {
            LOG.warn((Object)("Direct storage information for " + StorageProperties.NAME + " not found. Loading defaults."));
            try {
                conf = (DirectStorageInfo)((Object)Transactions.saveDirect((Object)((Object)new DirectStorageInfo(StorageProperties.NAME, "eth0", StorageProperties.storageRootDirectory, false, 10000L))));
            }
            catch (Exception e1) {
                try {
                    conf = (DirectStorageInfo)((Object)Transactions.find((Object)((Object)new DirectStorageInfo())));
                }
                catch (Exception e2) {
                    LOG.warn((Object)"Failed to persist and retrieve DirectStorageInfo entity");
                }
            }
        }
        if (conf == null) {
            conf = new DirectStorageInfo(StorageProperties.NAME, "eth0", StorageProperties.storageRootDirectory, false, 10000L);
        }
        return conf;
    }

    @Upgrades.EntityUpgrade(entities={DirectStorageInfo.class}, since=Upgrades.Version.v3_2_0, value=Storage.class)
    public static enum DirectStorageInfoUpgrade implements Predicate<Class>
    {
        INSTANCE;

        private static Logger LOG;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean apply(Class arg0) {
            try (TransactionResource tr = Entities.transactionFor(DirectStorageInfo.class);){
                List entities = Entities.query((Object)((Object)new DirectStorageInfo()));
                for (DirectStorageInfo entry : entities) {
                    LOG.debug((Object)("Upgrading: " + (Object)((Object)entry)));
                    entry.setTimeoutInMillis(10000L);
                }
                tr.commit();
                boolean bl = true;
                return bl;
            }
            catch (Exception ex) {
                throw Exceptions.toUndeclared((Throwable)ex);
            }
        }

        static {
            LOG = Logger.getLogger(DirectStorageInfoUpgrade.class);
        }
    }
}

