/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.blockstorage.entities;

import com.eucalyptus.blockstorage.util.StorageProperties;
import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableField;
import com.eucalyptus.configurable.ConfigurableIdentifier;
import com.eucalyptus.entities.AbstractPersistent;
import com.eucalyptus.entities.Transactions;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_storage")
@Table(name="das_info")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
@ConfigurableClass(root="storage", alias="das", description="Basic storage controller configuration for DAS.", singleton=false, deferred=true)
public class DASInfo
extends AbstractPersistent {
    private static Logger LOG = Logger.getLogger(DASInfo.class);
    @ConfigurableIdentifier
    @Column(name="storage_name", unique=true)
    private String name;
    @ConfigurableField(description="Direct attached storage device location", displayName="Direct attached block device or volume group")
    @Column(name="das_device")
    private String DASDevice;

    public DASInfo() {
        this.name = StorageProperties.NAME;
    }

    public DASInfo(String name) {
        this.name = name;
    }

    public DASInfo(String name, String DASDevice) {
        this.name = name;
        this.DASDevice = DASDevice;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDASDevice() {
        return this.DASDevice;
    }

    public void setDASDevice(String DASDevice) {
        this.DASDevice = DASDevice;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        DASInfo other = (DASInfo)((Object)obj);
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public String toString() {
        return this.name;
    }

    public static DASInfo getStorageInfo() {
        DASInfo conf = null;
        try {
            conf = (DASInfo)((Object)Transactions.find((Object)((Object)new DASInfo())));
        }
        catch (Exception e) {
            LOG.warn((Object)("DAS information for " + StorageProperties.NAME + " not found. Loading defaults."));
            try {
                conf = (DASInfo)((Object)Transactions.saveDirect((Object)((Object)new DASInfo(StorageProperties.NAME, StorageProperties.DAS_DEVICE))));
            }
            catch (Exception e1) {
                try {
                    conf = (DASInfo)((Object)Transactions.find((Object)((Object)new DASInfo())));
                }
                catch (Exception e2) {
                    LOG.warn((Object)"Failed to persist and retrieve DASInfo entity");
                }
            }
        }
        if (conf == null) {
            conf = new DASInfo(StorageProperties.NAME, StorageProperties.DAS_DEVICE);
        }
        return conf;
    }
}

