/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.blockstorage.entities;

import com.eucalyptus.blockstorage.Storage;
import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableField;
import com.eucalyptus.entities.AbstractPersistent;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.Transactions;
import com.eucalyptus.upgrade.Upgrades;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.walrus.entities.WalrusInfo;
import com.google.common.base.Predicate;
import javax.annotation.Nullable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityTransaction;
import javax.persistence.PersistenceContext;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_storage")
@Table(name="blockstorage_global_configuration")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
@ConfigurableClass(root="storage", description="Basic storage controller configuration.", singleton=true, deferred=true)
public class BlockStorageGlobalConfiguration
extends AbstractPersistent {
    private static Logger LOG = Logger.getLogger(BlockStorageGlobalConfiguration.class);
    private static final int DEFAULT_GLOBAL_TOTAL_SNAPSHOT_SIZE_GB = 50;
    @ConfigurableField(description="Maximum total snapshot capacity (GB)", displayName="Maximum total size allowed for snapshots", initial="50")
    @Column(name="global_total_snapshot_size_limit_gb")
    private Integer global_total_snapshot_size_limit_gb;

    public Integer getGlobal_total_snapshot_size_limit_gb() {
        return this.global_total_snapshot_size_limit_gb;
    }

    public void setGlobal_total_snapshot_size_limit_gb(Integer global_total_snapshot_size_limit_gb) {
        this.global_total_snapshot_size_limit_gb = global_total_snapshot_size_limit_gb;
    }

    @PrePersist
    private void initalize() {
        if (this.global_total_snapshot_size_limit_gb == null) {
            this.global_total_snapshot_size_limit_gb = 50;
        }
    }

    public static BlockStorageGlobalConfiguration getInstance() {
        BlockStorageGlobalConfiguration config = null;
        try {
            config = (BlockStorageGlobalConfiguration)((Object)Transactions.find((Object)((Object)new BlockStorageGlobalConfiguration())));
        }
        catch (Exception e) {
            try {
                config = (BlockStorageGlobalConfiguration)((Object)Transactions.save((Object)((Object)new BlockStorageGlobalConfiguration())));
            }
            catch (Exception e1) {
                LOG.warn((Object)"Failed to load and save block storage global configuration");
                config = new BlockStorageGlobalConfiguration();
                config.initalize();
            }
        }
        return config;
    }

    @Upgrades.EntityUpgrade(entities={BlockStorageGlobalConfiguration.class}, since=Upgrades.Version.v4_0_0, value=Storage.class)
    public static enum BSGC400Upgrade implements Predicate<Class>
    {
        INSATANCE;

        private static final Logger LOG;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean apply(@Nullable Class arg0) {
            EntityTransaction tran = Entities.get(BlockStorageGlobalConfiguration.class);
            try {
                WalrusInfo walrusConfig = WalrusInfo.getWalrusInfo();
                BlockStorageGlobalConfiguration config = null;
                try {
                    config = (BlockStorageGlobalConfiguration)((Object)Entities.uniqueResult((Object)((Object)new BlockStorageGlobalConfiguration())));
                    config.setGlobal_total_snapshot_size_limit_gb(walrusConfig.getStorageMaxTotalSnapshotSizeInGb());
                }
                catch (Exception e) {
                    config = new BlockStorageGlobalConfiguration();
                    config.setGlobal_total_snapshot_size_limit_gb(walrusConfig.getStorageMaxTotalSnapshotSizeInGb());
                    Entities.persist((Object)((Object)config));
                }
                tran.commit();
            }
            catch (Exception e) {
                LOG.error((Object)"Error upgrading blockstorage global configuration", (Throwable)e);
                tran.rollback();
                Exceptions.toUndeclared((String)"Error upgrading blockstorage global configuration", (Throwable[])new Exception[]{e});
            }
            finally {
                if (tran.isActive()) {
                    tran.rollback();
                }
            }
            return true;
        }

        static {
            LOG = Logger.getLogger(BSGC400Upgrade.class);
        }
    }
}

