/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.blockstorage.ceph.entities;

import com.eucalyptus.blockstorage.util.StorageProperties;
import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableField;
import com.eucalyptus.configurable.ConfigurableIdentifier;
import com.eucalyptus.crypto.Crypto;
import com.eucalyptus.entities.AbstractPersistent;
import com.eucalyptus.entities.Transactions;
import com.google.common.base.Strings;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.PersistenceContext;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_storage")
@Table(name="ceph_rbd_info")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
@ConfigurableClass(root="storage", alias="cephrbd", description="Configuration for Ceph as an EBS backend", singleton=false, deferred=true)
public class CephRbdInfo
extends AbstractPersistent {
    private static final long serialVersionUID = 1L;
    private static Logger LOG = Logger.getLogger(CephRbdInfo.class);
    public static final String POOL_IMAGE_DELIMITER = "/";
    public static final String IMAGE_SNAPSHOT_DELIMITER = "@";
    public static final String SNAPSHOT_ON_PREFIX = "sp-on-";
    public static final String SNAPSHOT_FOR_PREFIX = "sp-for-";
    private static final String DEFAULT_CEPH_USER = "eucalyptus";
    private static final String DEFAULT_CEPH_KEYRING_FILE = "/etc/ceph/ceph.client.eucalyptus.keyring";
    private static final String DEFAULT_CEPH_CONFIG_FILE = "/etc/ceph/ceph.conf";
    private static final String DEFAULT_POOL = "rbd";
    private static final String DELETED_IMAGE_COMMON_PREFIX = "del";
    @ConfigurableIdentifier
    @Column(name="cluster_name", unique=true)
    private String clusterName = StorageProperties.NAME;
    @ConfigurableField(description="Ceph username employed by Eucalyptus operations. Default value is 'eucalyptus'", displayName="Ceph Username", initial="eucalyptus")
    @Column(name="ceph_user")
    private String cephUser;
    @ConfigurableField(description="Absolute path to Ceph keyring (ceph.client.eucalyptus.keyring) file. Default value is '/etc/ceph/ceph.client.eucalyptus.keyring'", displayName="Ceph Keyring File", initial="/etc/ceph/ceph.client.eucalyptus.keyring")
    @Column(name="ceph_keyring_file")
    private String cephKeyringFile;
    @ConfigurableField(description="Absolute path to Ceph configuration (ceph.conf) file. Default value is '/etc/ceph/ceph.conf'", displayName="Ceph Configuration File", initial="/etc/ceph/ceph.conf")
    @Column(name="ceph_config_file")
    private String cephConfigFile;
    @ConfigurableField(description="Ceph storage pool(s) made available to Eucalyptus for EBS volumes. Use a comma separated list for configuring multiple pools. Default value is 'rbd'", displayName="Ceph Volume Pools", initial="rbd")
    @Column(name="ceph_volume_pools")
    private String cephVolumePools;
    @ConfigurableField(description="Ceph storage pool(s) made available to Eucalyptus for EBS snapshots. Use a comma separated list for configuring multiple pools. Default value is 'rbd'", displayName="Ceph Snapshot Pools", initial="rbd")
    @Column(name="ceph_snapshot_pools")
    private String cephSnapshotPools;
    @Column(name="virsh_secret")
    private String virshSecret;
    @Column(name="deleted_image_prefix")
    private String deletedImagePrefix;

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getCephUser() {
        return this.cephUser;
    }

    public void setCephUser(String cephUser) {
        this.cephUser = cephUser;
    }

    public String getCephKeyringFile() {
        return this.cephKeyringFile;
    }

    public void setCephKeyringFile(String cephKeyringFile) {
        this.cephKeyringFile = cephKeyringFile;
    }

    public String getCephConfigFile() {
        return this.cephConfigFile;
    }

    public void setCephConfigFile(String cephConfigFile) {
        this.cephConfigFile = cephConfigFile;
    }

    public String getCephVolumePools() {
        return this.cephVolumePools;
    }

    public void setCephVolumePools(String cephVolumePools) {
        this.cephVolumePools = cephVolumePools;
    }

    public String getCephSnapshotPools() {
        return this.cephSnapshotPools;
    }

    public void setCephSnapshotPools(String cephSnapshotPools) {
        this.cephSnapshotPools = cephSnapshotPools;
    }

    public String getVirshSecret() {
        return this.virshSecret;
    }

    public void setVirshSecret(String virshSecret) {
        this.virshSecret = virshSecret;
    }

    public String getDeletedImagePrefix() {
        return this.deletedImagePrefix;
    }

    public void setDeletedImagePrefix(String deletedImagePrefix) {
        this.deletedImagePrefix = deletedImagePrefix;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.clusterName == null ? 0 : this.clusterName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        CephRbdInfo other = (CephRbdInfo)((Object)obj);
        return !(this.clusterName == null ? other.clusterName != null : !this.clusterName.equals(other.clusterName));
    }

    public String toString() {
        return "[cephuser=" + this.cephUser + ", cephkeyringfile=" + this.cephKeyringFile + ", cephconfigfile=" + this.cephConfigFile + ", cephvolumepools=" + this.cephVolumePools + ", cephsnapshotPools=" + this.cephSnapshotPools + "]";
    }

    @PrePersist
    public void checkPrePersist() {
        if (Strings.isNullOrEmpty((String)this.virshSecret)) {
            this.virshSecret = UUID.randomUUID().toString();
        }
        if (Strings.isNullOrEmpty((String)this.deletedImagePrefix)) {
            this.deletedImagePrefix = DELETED_IMAGE_COMMON_PREFIX + Crypto.generateAlphanumericId((int)8, (String)"") + '-';
        }
    }

    public boolean isSame(CephRbdInfo other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (this.clusterName == null ? other.clusterName != null : !this.clusterName.equals(other.clusterName)) {
            return false;
        }
        if (this.cephUser == null ? other.cephUser != null : !this.cephUser.equals(other.cephUser)) {
            return false;
        }
        if (this.cephKeyringFile == null ? other.cephKeyringFile != null : !this.cephKeyringFile.equals(other.cephKeyringFile)) {
            return false;
        }
        if (this.cephConfigFile == null ? other.cephConfigFile != null : !this.cephConfigFile.equals(other.cephConfigFile)) {
            return false;
        }
        if (this.cephVolumePools == null ? other.cephVolumePools != null : !this.cephVolumePools.equals(other.cephVolumePools)) {
            return false;
        }
        return !(this.cephSnapshotPools == null ? other.getCephSnapshotPools() != null : !this.cephSnapshotPools.equals(other.cephSnapshotPools));
    }

    private static CephRbdInfo generateDefault() {
        CephRbdInfo info = new CephRbdInfo();
        info.setCephUser(DEFAULT_CEPH_USER);
        info.setCephKeyringFile(DEFAULT_CEPH_KEYRING_FILE);
        info.setCephConfigFile(DEFAULT_CEPH_CONFIG_FILE);
        info.setCephVolumePools(DEFAULT_POOL);
        info.setCephSnapshotPools(DEFAULT_POOL);
        return info;
    }

    public static CephRbdInfo getStorageInfo() {
        CephRbdInfo info = null;
        try {
            info = (CephRbdInfo)((Object)Transactions.find((Object)((Object)new CephRbdInfo())));
        }
        catch (Exception e) {
            LOG.warn((Object)("Ceph-RBD information for " + StorageProperties.NAME + " not found. Loading defaults."));
            try {
                info = (CephRbdInfo)((Object)Transactions.saveDirect((Object)((Object)CephRbdInfo.generateDefault())));
            }
            catch (Exception e1) {
                try {
                    info = (CephRbdInfo)((Object)Transactions.find((Object)((Object)new CephRbdInfo())));
                }
                catch (Exception e2) {
                    LOG.warn((Object)"Failed to persist and retrieve CephInfo entity");
                }
            }
        }
        if (info == null) {
            info = CephRbdInfo.generateDefault();
        }
        return info;
    }
}

