/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.blockstorage.ceph;

import com.ceph.rbd.RbdImage;
import com.eucalyptus.blockstorage.StorageResource;
import com.eucalyptus.blockstorage.ceph.CephRbdConnectionManager;
import com.eucalyptus.blockstorage.ceph.CephRbdInputStream;
import com.eucalyptus.blockstorage.ceph.CephRbdOutputStream;
import com.eucalyptus.blockstorage.ceph.entities.CephRbdInfo;
import com.eucalyptus.blockstorage.ceph.exceptions.EucalyptusCephException;
import com.eucalyptus.blockstorage.exceptions.UnknownSizeException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.log4j.Logger;

public class CephRbdResource
extends StorageResource {
    private static final Logger LOG = Logger.getLogger(CephRbdResource.class);
    private String imageName = null;
    private String poolName = null;
    private CephRbdInfo info = CephRbdInfo.getStorageInfo();

    public CephRbdResource(String id, String path) {
        super(id, path, StorageResource.Type.CEPH);
        String[] poolImage = path.split("/");
        if (poolImage == null || poolImage.length != 2) {
            LOG.warn((Object)("Invalid format for path CephImageResource, expected pool/image but got " + path));
            throw new EucalyptusCephException("Invalid format for path CephImageResource, expected pool/image but got " + path);
        }
        this.poolName = poolImage[0];
        this.imageName = poolImage[1];
    }

    @Override
    public Boolean isDownloadSynchronous() {
        return Boolean.FALSE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long getSize() throws UnknownSizeException {
        CephRbdConnectionManager conn = null;
        try {
            Long l;
            block10: {
                conn = CephRbdConnectionManager.getConnection(this.info, this.poolName);
                RbdImage rbdImage = null;
                try {
                    rbdImage = conn.getRbd().open(this.imageName);
                    l = rbdImage.stat().size;
                    if (rbdImage == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (rbdImage != null) {
                            conn.getRbd().close(rbdImage);
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw new UnknownSizeException("Failed to determine size of ceph image " + this.imageName + " in pool " + this.poolName, e);
                    }
                }
                conn.getRbd().close(rbdImage);
            }
            return l;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    @Override
    public InputStream getInputStream() throws Exception {
        return new CephRbdInputStream(this.imageName, this.poolName, this.info);
    }

    @Override
    public OutputStream getOutputStream() throws Exception {
        return new CephRbdOutputStream(this.imageName, this.poolName, this.info);
    }
}

