/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.blockstorage.ceph;

import com.ceph.rbd.RbdImage;
import com.eucalyptus.blockstorage.ceph.CephRbdConnectionManager;
import com.eucalyptus.blockstorage.ceph.entities.CephRbdInfo;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;

public class CephRbdInputStream
extends InputStream {
    private static final Logger LOG = Logger.getLogger(CephRbdInputStream.class);
    private CephRbdConnectionManager conn;
    private RbdImage rbdImage;
    private long position;
    private boolean isOpen;

    public CephRbdInputStream(String imageName, String poolName, CephRbdInfo info) throws IOException {
        try {
            this.conn = CephRbdConnectionManager.getConnection(info, poolName);
            this.rbdImage = this.conn.getRbd().open(imageName);
            this.isOpen = true;
            this.position = 0L;
        }
        catch (Exception e) {
            throw new IOException("Failed to open CephInputStream for image " + imageName + " in pool " + poolName, e);
        }
    }

    @Override
    public int read() throws IOException {
        if (this.isOpen) {
            byte[] buffer = new byte[1];
            int bytesRead = 0;
            bytesRead = this.rbdImage.read(this.position, buffer, buffer.length);
            if (bytesRead > 0) {
                this.position += (long)bytesRead;
                return buffer[0];
            }
            return -1;
        }
        throw new IOException("Stream is not open/initialized");
    }

    @Override
    public int read(byte[] b, int off, int len) throws NullPointerException, IndexOutOfBoundsException, IOException {
        if (null == b) {
            throw new NullPointerException("Input byte buffer cannot be null");
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException("Offset or length cannot be negative. Length cannot be smaller than available size in buffer");
        }
        if (this.isOpen) {
            byte[] buffer = new byte[len];
            int bytesRead = 0;
            bytesRead = this.rbdImage.read(this.position, buffer, buffer.length);
            if (bytesRead > 0) {
                this.position += (long)bytesRead;
                for (int i = 0; i < bytesRead; ++i) {
                    b[off + i] = buffer[i];
                }
                return bytesRead;
            }
            return -1;
        }
        throw new IOException("Stream is not open/initialized");
    }

    @Override
    public int read(byte[] b) throws NullPointerException, IOException {
        if (null == b) {
            throw new NullPointerException("Input byte buffer cannot be null");
        }
        return this.read(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.isOpen) {
            try {
                this.conn.getRbd().close(this.rbdImage);
            }
            catch (Exception exception) {
            }
            finally {
                this.isOpen = false;
                this.conn.disconnect();
                this.conn = null;
                this.rbdImage = null;
            }
        }
    }
}

