/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.blockstorage.ceph;

import com.ceph.rados.IoCTX;
import com.ceph.rados.Rados;
import com.ceph.rados.exceptions.RadosException;
import com.ceph.rbd.Rbd;
import com.eucalyptus.blockstorage.ceph.entities.CephRbdInfo;
import com.eucalyptus.blockstorage.ceph.exceptions.EucalyptusCephException;
import java.io.File;
import java.util.Random;
import org.apache.log4j.Logger;

public class CephRbdConnectionManager {
    private static Logger LOG = Logger.getLogger(CephRbdConnectionManager.class);
    private static Random randomGenerator = new Random();
    private static final String KEYRING = "keyring";
    private Rados rados;
    private IoCTX ioContext;
    private Rbd rbd;
    private String pool;

    private CephRbdConnectionManager(CephRbdInfo config, String poolName) {
        try {
            this.rados = new Rados(config.getCephUser());
            this.rados.confSet(KEYRING, config.getCephKeyringFile());
            this.rados.confReadFile(new File(config.getCephConfigFile()));
            this.rados.connect();
            this.pool = poolName;
            this.ioContext = this.rados.ioCtxCreate(this.pool);
            this.rbd = new Rbd(this.ioContext);
        }
        catch (RadosException e) {
            this.disconnect();
            LOG.warn((Object)"Unable to connect to Ceph cluster");
            throw new EucalyptusCephException("Failed to connect to pool " + poolName + " in Ceph cluster. Verify Ceph cluster health, privileges of Ceph user assigned to Eucalyptus, Ceph parameters configured in Eucalyptus " + config.toString() + " and retry operation", e);
        }
    }

    public Rados getRados() {
        return this.rados;
    }

    public IoCTX getIoContext() {
        return this.ioContext;
    }

    public Rbd getRbd() {
        return this.rbd;
    }

    public String getPool() {
        return this.pool;
    }

    public void disconnect() {
        if (this.rados != null && this.ioContext != null) {
            this.rados.ioCtxDestroy(this.ioContext);
            this.rados = null;
            this.ioContext = null;
            this.rbd = null;
            this.pool = null;
        }
    }

    public static CephRbdConnectionManager getConnection(CephRbdInfo config, String poolName) {
        return new CephRbdConnectionManager(config, poolName);
    }

    public static CephRbdConnectionManager getRandomVolumePoolConnection(CephRbdInfo config) {
        String[] allPools = CephRbdConnectionManager.getAllVolumePools(config);
        return new CephRbdConnectionManager(config, allPools[randomGenerator.nextInt(allPools.length)]);
    }

    public static CephRbdConnectionManager getRandomSnapshotPoolConnection(CephRbdInfo config) {
        String[] allPools = CephRbdConnectionManager.getAllSnapshotPools(config);
        return new CephRbdConnectionManager(config, allPools[randomGenerator.nextInt(allPools.length)]);
    }

    public static String[] getAllVolumePools(CephRbdInfo config) {
        String[] allPools = config.getCephVolumePools().split(",");
        if (allPools != null && allPools.length > 0) {
            return allPools;
        }
        LOG.warn((Object)"No ceph pools defined, retry after defining at least one pool using euca-modify-property -p <cluster>.storage.cephvolumepools=<pool-name>");
        throw new EucalyptusCephException("No ceph pools defined, retry after defining at least one pool using euca-modify-property -p <cluster>.storage.cephvolumepools=<pool-name>");
    }

    public static String[] getAllSnapshotPools(CephRbdInfo config) {
        String[] allPools = config.getCephSnapshotPools().split(",");
        if (allPools != null && allPools.length > 0) {
            return allPools;
        }
        LOG.warn((Object)"No ceph pools defined, retry after defining at least one pool using euca-modify-property -p <cluster>.storage.cephsnapshotpools=<pool-name>");
        throw new EucalyptusCephException("No ceph pools defined, retry after defining at least one pool using euca-modify-property -p <cluster>.storage.cephsnapshotpools=<pool-name>");
    }
}

