/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.blockstorage;

import com.eucalyptus.binding.BindingManager;
import com.eucalyptus.blockstorage.msgs.StorageErrorMessageType;
import edu.ucsb.eucalyptus.cloud.NoSuchSnapshotException;
import edu.ucsb.eucalyptus.cloud.NoSuchVolumeException;
import edu.ucsb.eucalyptus.cloud.SnapshotInUseException;
import edu.ucsb.eucalyptus.cloud.VolumeAlreadyExistsException;
import edu.ucsb.eucalyptus.cloud.VolumeInUseException;
import edu.ucsb.eucalyptus.cloud.VolumeNotReadyException;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import edu.ucsb.eucalyptus.msgs.EucalyptusErrorMessageType;
import edu.ucsb.eucalyptus.msgs.EucalyptusMessage;
import edu.ucsb.eucalyptus.util.ReplyCoordinator;
import org.apache.log4j.Logger;
import org.mule.message.ExceptionMessage;

public class StorageReplyQueue {
    private static Logger LOG = Logger.getLogger(StorageReplyQueue.class);
    private static ReplyCoordinator replies = new ReplyCoordinator(3600000L);

    public void handle(EucalyptusMessage msg) {
        Logger.getLogger(StorageReplyQueue.class).warn((Object)("storage queueing reply to " + msg.getCorrelationId()));
        replies.putMessage((BaseMessage)msg);
    }

    public void handle(ExceptionMessage muleMsg) {
        try {
            Object requestMsg = muleMsg.getPayload();
            String requestString = requestMsg.toString();
            BaseMessage msg = (BaseMessage)BindingManager.getDefaultBinding().fromOM(requestString);
            Throwable ex = muleMsg.getException().getCause();
            StorageErrorMessageType errMsg = null;
            if (ex instanceof NoSuchVolumeException) {
                errMsg = new StorageErrorMessageType("NoSuchVolume", "Volume not found", 404, msg.getCorrelationId());
                errMsg.setCorrelationId(msg.getCorrelationId());
            } else if (ex instanceof VolumeInUseException) {
                errMsg = new StorageErrorMessageType("VolumeInUse", "Volume in use", 403, msg.getCorrelationId());
                errMsg.setCorrelationId(msg.getCorrelationId());
            } else if (ex instanceof NoSuchSnapshotException) {
                errMsg = new StorageErrorMessageType("NoSuchSnapshot", "Snapshot not found", 404, msg.getCorrelationId());
                errMsg.setCorrelationId(msg.getCorrelationId());
            } else if (ex instanceof VolumeAlreadyExistsException) {
                errMsg = new StorageErrorMessageType("VolumeAlreadyExists", "Volume already exists", 409, msg.getCorrelationId());
                errMsg.setCorrelationId(msg.getCorrelationId());
            } else if (ex instanceof VolumeNotReadyException) {
                errMsg = new StorageErrorMessageType("VolumeNotReady", "Volume not ready yet", 409, msg.getCorrelationId());
                errMsg.setCorrelationId(msg.getCorrelationId());
            } else if (ex instanceof SnapshotInUseException) {
                errMsg = new StorageErrorMessageType("SnapshotInUse", "Snapshot in use", 409, msg.getCorrelationId());
                errMsg.setCorrelationId(msg.getCorrelationId());
            } else {
                replies.putMessage((BaseMessage)new EucalyptusErrorMessageType(muleMsg.getComponentName(), msg, ex.getMessage()));
            }
            if (errMsg != null) {
                replies.putMessage((BaseMessage)errMsg);
            }
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
    }

    public static BaseMessage getReply(String msgId) {
        Logger.getLogger(StorageReplyQueue.class).warn((Object)("storage request for reply to " + msgId));
        BaseMessage msg = replies.getMessage(msgId);
        Logger.getLogger(StorageReplyQueue.class).warn((Object)("storage obtained reply to " + msgId));
        return msg;
    }
}

