/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.blockstorage;

import com.eucalyptus.blockstorage.StorageResource;
import com.eucalyptus.blockstorage.exceptions.UnknownSizeException;
import com.eucalyptus.blockstorage.util.StorageProperties;
import edu.ucsb.eucalyptus.util.SystemUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class BlockDeviceResource
extends StorageResource {
    private static final int ATTEMPTS = 10;
    private static Logger LOG = Logger.getLogger(BlockDeviceResource.class);

    public BlockDeviceResource(String id, String name) {
        super(id, name, StorageResource.Type.BLOCK);
    }

    @Override
    public Long getSize() throws UnknownSizeException {
        Long size = 0L;
        try {
            SystemUtil.CommandOutput result = SystemUtil.runWithRawOutput((String[])new String[]{StorageProperties.EUCA_ROOT_WRAPPER, "blockdev", "--getsize64", this.getPath()});
            size = Long.parseLong(StringUtils.trimToEmpty((String)result.output));
            return size;
        }
        catch (Exception e) {
            throw new UnknownSizeException("Failed to determine size for " + this.getId() + " mounted at " + this.getPath(), e);
        }
    }

    @Override
    public InputStream getInputStream() throws FileNotFoundException {
        return new FileInputStream(new File(this.getPath()));
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        FileOutputStream outStream = null;
        int failedAttempts = 0;
        while (true) {
            try {
                outStream = new FileOutputStream(new File(this.getPath()));
                return outStream;
            }
            catch (FileNotFoundException e) {
                if (++failedAttempts >= 10) {
                    LOG.warn((Object)("Failed to open FileOutputStream for " + this.getId() + " mounted at " + this.getPath() + " after " + failedAttempts + " attempts"));
                    throw e;
                }
                LOG.debug((Object)("Failed to open FileOutputStream for " + this.getId() + " mounted at " + this.getPath() + ". Will retry"));
                if (failedAttempts < 10) continue;
                throw new IOException("Failed to open FileOutputStream for " + this.getId() + " mounted at " + this.getPath());
            }
            break;
        }
    }

    @Override
    public Boolean isDownloadSynchronous() {
        return Boolean.TRUE;
    }
}

