/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.storage.config;

import com.eucalyptus.storage.config.CacheableConfiguration;
import com.eucalyptus.util.Exceptions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.TimeUnit;

public class ConfigurationCache {
    private static final long ENTRY_EXPIRATION_TIME_SEC = 5L;
    protected static final LoadingCache<Class<? extends CacheableConfiguration>, CacheableConfiguration> configCache = CacheBuilder.newBuilder().refreshAfterWrite(5L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<Class<? extends CacheableConfiguration>, CacheableConfiguration>(){

        public CacheableConfiguration load(Class<? extends CacheableConfiguration> aClass) throws Exception {
            return (CacheableConfiguration)aClass.newInstance().getLatest();
        }
    });

    public static <T extends CacheableConfiguration> T getConfiguration(Class<T> configType) {
        try {
            return (T)((CacheableConfiguration)configCache.get(configType));
        }
        catch (Throwable f) {
            throw Exceptions.toUndeclared((String)("No configuration entry found for type " + configType.getName()), (Throwable[])new Throwable[]{f});
        }
    }
}

