/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.storage.common.fs;

import com.eucalyptus.storage.common.fs.FileIO;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.log4j.Logger;

public class FileReader
extends FileIO {
    private static Logger LOG = Logger.getLogger(FileReader.class);
    private ByteBuffer buffer;

    public FileReader(String filename) throws Exception {
        try {
            this.channel = new FileInputStream(filename).getChannel();
            this.buffer = ByteBuffer.allocate(102400);
        }
        catch (FileNotFoundException ex) {
            LOG.error((Object)ex);
            throw ex;
        }
    }

    @Override
    public int read(long offset) throws IOException {
        this.buffer.clear();
        int bytesRead = this.channel.read(this.buffer, offset);
        this.buffer.flip();
        return bytesRead;
    }

    @Override
    public void write(byte[] bytes) throws IOException {
    }

    @Override
    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    @Override
    public void finish() {
        try {
            this.channel.close();
        }
        catch (IOException ex) {
            LOG.error((Object)ex);
        }
    }
}

