/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.storage.common;

import edu.ucsb.eucalyptus.constants.IsData;
import java.io.ByteArrayOutputStream;
import java.io.RandomAccessFile;
import java.util.zip.GZIPOutputStream;
import org.apache.log4j.Logger;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.handler.stream.ChunkedInput;

public class CompressedChunkedFile
implements ChunkedInput,
IsData {
    private Logger LOG = Logger.getLogger(CompressedChunkedFile.class);
    private RandomAccessFile file;
    private long offset;
    private int CHUNK_SIZE = 8192;
    private long fileLength;

    public CompressedChunkedFile(RandomAccessFile file, long fileLength) {
        this.file = file;
        this.offset = 0L;
        this.fileLength = fileLength;
    }

    public CompressedChunkedFile(RandomAccessFile file, long start, long end, int chunkSize) {
        this.file = file;
        this.offset = start;
        this.fileLength = end;
        this.CHUNK_SIZE = chunkSize;
    }

    public void close() throws Exception {
        this.file.close();
    }

    public boolean hasNextChunk() throws Exception {
        return this.offset < this.fileLength && this.file.getChannel().isOpen();
    }

    public Object nextChunk() throws Exception {
        long offset = this.offset;
        if (offset >= this.fileLength) {
            return null;
        }
        int chunkSize = (int)Math.min((long)this.CHUNK_SIZE, this.fileLength - offset);
        byte[] chunk = new byte[chunkSize];
        this.file.readFully(chunk);
        this.offset = offset + (long)chunkSize;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GZIPOutputStream zip = new GZIPOutputStream(out);
        zip.write(chunk);
        zip.close();
        return ChannelBuffers.wrappedBuffer((byte[])out.toByteArray());
    }

    public boolean isEndOfInput() throws Exception {
        return !this.hasNextChunk();
    }
}

