/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth.util;

import com.eucalyptus.auth.DatabaseAuthBootstrapper;
import com.eucalyptus.util.Exceptions;
import com.google.common.base.CaseFormat;
import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;

public abstract class ClassPathSystemRoleProvider
implements DatabaseAuthBootstrapper.SystemRoleProvider {
    @Override
    public String getAssumeRolePolicy() {
        return this.loadPolicy(this.getResourceName("AssumeRolePolicy"));
    }

    @Override
    public String getPolicy() {
        return this.loadPolicy(this.getResourceName("Policy"));
    }

    private String getResourceName(String type) {
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_HYPHEN, this.getName() + type) + ".json";
    }

    private String loadPolicy(String resourceName) {
        try {
            return Resources.toString((URL)Resources.getResource(this.getClass(), (String)resourceName), (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            throw Exceptions.toUndeclared((Throwable)e);
        }
    }
}

