/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth.policy.key;

import com.eucalyptus.auth.Accounts;
import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.PolicyResourceContext;
import com.eucalyptus.auth.policy.condition.Bool;
import com.eucalyptus.auth.policy.condition.ConditionOp;
import com.eucalyptus.auth.policy.key.Key;
import com.eucalyptus.auth.policy.key.PolicyKey;
import com.eucalyptus.auth.principal.Account;
import com.eucalyptus.util.Exceptions;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.sf.json.JSONException;

@PolicyKey(value="aws:systemresource")
public class SystemResourceKey
implements Key {
    static final String KEY_NAME = "aws:systemresource";
    private static final LoadingCache<String, Boolean> systemAccountCache = CacheBuilder.newBuilder().expireAfterAccess(15L, TimeUnit.MINUTES).maximumSize(1000L).build(CacheLoader.from((Function)SystemAccountLookup.INSTANCE));

    public String value() throws AuthException {
        Optional accountNumberOptional = PolicyResourceContext.AccountNumberPolicyResourceInterceptor.getCurrentResourceAccountNumber();
        if (accountNumberOptional.isPresent()) {
            try {
                return String.valueOf(systemAccountCache.getUnchecked(accountNumberOptional.get()));
            }
            catch (RuntimeException e) {
                throw Exceptions.rethrow((RuntimeException)e, AuthException.class);
            }
        }
        throw new AuthException("Resource account not found");
    }

    public void validateConditionType(Class<? extends ConditionOp> conditionClass) throws JSONException {
        if (!Bool.class.isAssignableFrom(conditionClass)) {
            throw new JSONException("aws:systemresource is not allowed in condition " + conditionClass.getName() + ". Boolean conditions are required.");
        }
    }

    public void validateValueType(String value) throws JSONException {
    }

    public boolean canApply(String action, String resourceType) {
        return true;
    }

    private static enum SystemAccountLookup implements Function<String, Boolean>
    {
        INSTANCE;


        @Nullable
        public Boolean apply(@Nullable String accountNumber) {
            try {
                Account account = Accounts.lookupAccountById((String)accountNumber);
                return Accounts.isSystemAccount((Account)account) && !"eucalyptus".equals(account.getName());
            }
            catch (AuthException e) {
                throw Exceptions.toUndeclared((Throwable)e);
            }
        }
    }
}

