/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth.policy.key;

import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.policy.condition.AddressConditionOp;
import com.eucalyptus.auth.policy.condition.ConditionOp;
import com.eucalyptus.auth.policy.key.Key;
import com.eucalyptus.auth.policy.key.KeyUtils;
import com.eucalyptus.auth.policy.key.PolicyKey;
import com.eucalyptus.context.Context;
import com.eucalyptus.context.Contexts;
import net.sf.json.JSONException;

@PolicyKey(value="aws:sourceip", evaluationConstraints={Key.EvaluationConstraint.ReceivingHost})
public class SourceIp
implements Key {
    private static final String KEY = "aws:sourceip";

    public String value() throws AuthException {
        try {
            Context context = Contexts.lookup();
            return context.getRemoteAddress().getHostAddress();
        }
        catch (Exception e) {
            throw new AuthException("Unable to retrieve current request IP address for authorization", (Throwable)e);
        }
    }

    public void validateConditionType(Class<? extends ConditionOp> conditionClass) throws JSONException {
        if (!AddressConditionOp.class.isAssignableFrom(conditionClass)) {
            throw new JSONException("aws:sourceip is not allowed in condition " + conditionClass.getName() + ". Address conditions are required.");
        }
    }

    public void validateValueType(String value) throws JSONException {
        KeyUtils.validateCidrValue(value, KEY);
    }

    public boolean canApply(String action, String resourceType) {
        return true;
    }
}

