/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth.policy.key;

import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.policy.condition.ConditionOp;
import com.eucalyptus.auth.policy.condition.NumericLessThanEquals;
import com.eucalyptus.auth.policy.key.Key;
import com.eucalyptus.auth.principal.Authorization;
import net.sf.json.JSONException;

public abstract class QuotaKey
implements Key {
    public static final String NOT_SUPPORTED = "Not supported";
    public static final Long MB = 0x100000L;

    public abstract String value(Authorization.Scope var1, String var2, String var3, Long var4) throws AuthException;

    public final String value() throws AuthException {
        throw new RuntimeException("QuotaKey should not call the default value interface.");
    }

    public void validateConditionType(Class<? extends ConditionOp> conditionClass) throws JSONException {
        if (conditionClass != NumericLessThanEquals.class) {
            throw new JSONException("A quota key is not allowed in condition " + conditionClass.getName() + ". NumericLessThanEquals is required.");
        }
    }

    public static Long toMb(Long sizeInBytes) {
        return sizeInBytes / MB;
    }
}

