/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth.policy.key;

import com.eucalyptus.auth.Contract;
import com.eucalyptus.auth.policy.condition.ConditionOp;
import com.eucalyptus.auth.policy.condition.NumericLessThanEquals;
import com.eucalyptus.auth.policy.key.ContractKey;
import com.eucalyptus.auth.policy.key.KeyUtils;
import com.eucalyptus.auth.policy.key.PolicyKey;
import net.sf.json.JSONException;
import org.apache.log4j.Logger;

@PolicyKey(value="s3:max-keys")
public class MaxKeys
extends ContractKey<Long> {
    private static final Logger LOG = Logger.getLogger(MaxKeys.class);
    private static final String KEY = "s3:max-keys";
    private static final String ACTION_LISTBUCKET = "s3:listbucket";
    private static final String ACTION_LISTBUCKETVERSIONS = "s3:listbucketversions";
    private static final Long DEFAULT = 9999L;

    public void validateConditionType(Class<? extends ConditionOp> conditionClass) throws JSONException {
        if (conditionClass != NumericLessThanEquals.class) {
            throw new JSONException("s3:max-keys is not allowed in condition " + conditionClass.getName() + ". NumericLessThanEquals is required.");
        }
    }

    public void validateValueType(String value) throws JSONException {
        KeyUtils.validateIntegerValue(value, KEY);
    }

    @Override
    public Contract<Long> getContract(final String[] values) {
        return new Contract<Long>(){

            public Contract.Type getType() {
                return Contract.Type.MAXKEYS;
            }

            public Long getValue() {
                try {
                    return Long.valueOf(values[0]);
                }
                catch (Exception e) {
                    LOG.debug((Object)e, (Throwable)e);
                    return DEFAULT;
                }
            }
        };
    }

    public boolean canApply(String action, String resourceType) {
        return ACTION_LISTBUCKET.equals(action) || ACTION_LISTBUCKETVERSIONS.equals(action);
    }

    @Override
    public boolean isBetter(Contract<Long> current, Contract<Long> update) {
        return (Long)update.getValue() > (Long)current.getValue();
    }
}

