/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth.policy.key;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Iso8601DateParser {
    private static final Pattern DATE_PATTERN = Pattern.compile("(\\d\\d\\d\\d)(?:\\-(\\d\\d)(?:\\-(\\d\\d)(?:T(\\d\\d):(\\d\\d)(?::(\\d\\d)(?:\\.(\\d+))?)?(?:(Z)|(?:(\\+|\\-)(\\d\\d):(\\d\\d))))?)?)?");

    public static Date parse(String input) throws ParseException {
        SimpleDateFormat sdf;
        if (input == null || "".equals(input)) {
            throw new ParseException("Empty date string", 0);
        }
        boolean hasTzd = false;
        Matcher matcher = DATE_PATTERN.matcher(input);
        if (!matcher.matches()) {
            throw new ParseException("Invalid date string", 0);
        }
        if (matcher.group(2) == null) {
            sdf = new SimpleDateFormat("yyyy");
        } else if (matcher.group(3) == null) {
            sdf = new SimpleDateFormat("yyyy-MM");
        } else if (matcher.group(4) == null) {
            sdf = new SimpleDateFormat("yyyy-MM-dd");
        } else if (matcher.group(6) == null) {
            sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mmz");
            hasTzd = true;
        } else if (matcher.group(7) == null) {
            sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssz");
            hasTzd = true;
        } else {
            sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.'SSSz");
            hasTzd = true;
            int fractionLength = matcher.group(7).length();
            if (fractionLength > 3) {
                int dot = input.indexOf(46);
                input = input.substring(0, dot + 4) + input.substring(dot + fractionLength + 1);
            }
        }
        if (hasTzd) {
            if (matcher.group(8) != null) {
                input = input.replaceAll("Z", "+0000");
            } else {
                int length = input.length();
                input = input.substring(0, length - 3) + input.substring(length - 2);
            }
        }
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        Date ret = sdf.parse(input);
        return ret;
    }

    public static String toString(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.'S'Z'");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        String output = sdf.format(date);
        return output;
    }
}

