/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth.policy.key;

import com.eucalyptus.auth.Contract;
import com.eucalyptus.auth.policy.condition.ConditionOp;
import com.eucalyptus.auth.policy.condition.DateEquals;
import com.eucalyptus.auth.policy.key.ContractKey;
import com.eucalyptus.auth.policy.key.Iso8601DateParser;
import com.eucalyptus.auth.policy.key.KeyUtils;
import com.eucalyptus.auth.policy.key.PolicyKey;
import java.util.Date;
import net.sf.json.JSONException;
import org.apache.log4j.Logger;

@PolicyKey(value="ec2:expirationtime")
public class ExpirationTime
extends ContractKey<Date> {
    private static final Logger LOG = Logger.getLogger(ExpirationTime.class);
    private static final String KEY = "ec2:expirationtime";
    private static final String ACTION_RUNINSTANCES = "ec2:runinstances";
    private static final long YEAR = 31536000000L;

    public void validateConditionType(Class<? extends ConditionOp> conditionClass) throws JSONException {
        if (DateEquals.class != conditionClass) {
            throw new JSONException("ec2:expirationtime is not allowed in condition " + conditionClass.getName() + ". DateEquals is required.");
        }
    }

    public void validateValueType(String value) throws JSONException {
        KeyUtils.validateDateValue(value, KEY);
    }

    @Override
    public Contract<Date> getContract(final String[] values) {
        return new Contract<Date>(){

            public Contract.Type getType() {
                return Contract.Type.EXPIRATION;
            }

            public Date getValue() {
                return ExpirationTime.getExpiration(values[0]);
            }
        };
    }

    public boolean canApply(String action, String resourceType) {
        return ACTION_RUNINSTANCES.equals(action);
    }

    @Override
    public boolean isBetter(Contract<Date> current, Contract<Date> update) {
        return ((Date)update.getValue()).after((Date)current.getValue());
    }

    private static Date getExpiration(String expiration) {
        try {
            return Iso8601DateParser.parse(expiration);
        }
        catch (Exception e) {
            LOG.debug((Object)e, (Throwable)e);
            return new Date(System.currentTimeMillis() + 31536000000L);
        }
    }
}

