/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth.policy.key;

import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.policy.condition.ConditionOp;
import com.eucalyptus.auth.policy.condition.DateConditionOp;
import com.eucalyptus.auth.policy.key.Iso8601DateParser;
import com.eucalyptus.auth.policy.key.Key;
import com.eucalyptus.auth.policy.key.KeyUtils;
import com.eucalyptus.auth.policy.key.PolicyKey;
import java.util.Date;
import net.sf.json.JSONException;

@PolicyKey(value="aws:currenttime")
public class CurrentTime
implements Key {
    private static final String KEY = "aws:currenttime";

    public String value() throws AuthException {
        return Iso8601DateParser.toString(new Date());
    }

    public void validateConditionType(Class<? extends ConditionOp> conditionClass) throws JSONException {
        if (!DateConditionOp.class.isAssignableFrom(conditionClass)) {
            throw new JSONException("aws:currenttime is not allowed in condition " + conditionClass.getName() + ". Date conditions are required.");
        }
    }

    public void validateValueType(String value) throws JSONException {
        KeyUtils.validateDateValue(value, KEY);
    }

    public boolean canApply(String action, String resourceType) {
        return true;
    }
}

