/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth.policy.key;

import com.eucalyptus.auth.policy.key.CidrParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class Cidr {
    private static final Logger LOG = Logger.getLogger(Cidr.class);
    private static final Pattern CIDR_PATTERN = Pattern.compile("(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})(?:/(\\d{1,2}))?");
    private static final int PREFIX_32 = -1;
    private int prefix;
    private int mask;

    public Cidr(int prefix, int mask) {
        this.prefix = prefix;
        this.mask = mask;
    }

    public int getPrefix() {
        return this.prefix;
    }

    public int getMask() {
        return this.mask;
    }

    public boolean matchIp(String ip) {
        try {
            Cidr ipCidr = Cidr.valueOf(ip);
            if (ipCidr.getMask() != -1) {
                throw new CidrParseException();
            }
            return (ipCidr.getPrefix() & this.mask) == this.prefix;
        }
        catch (CidrParseException e) {
            LOG.error((Object)("Input IP address to match is invalid: " + ip), (Throwable)e);
            return false;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int bits = this.prefix;
        int lsb8 = 255;
        sb.append(bits >> 24 & 0xFF).append('.');
        sb.append(bits >> 16 & 0xFF).append('.');
        sb.append(bits >> 8 & 0xFF).append('.');
        sb.append(bits & 0xFF);
        if (this.mask != -1) {
            int count = 0;
            for (int maskBits = this.mask; maskBits != 0; maskBits <<= 1) {
                ++count;
            }
            sb.append('/').append(count);
        }
        return sb.toString();
    }

    public static Cidr valueOf(String cidr) throws CidrParseException {
        if (cidr == null || "".equals(cidr)) {
            throw new CidrParseException("Empty CIDR");
        }
        Matcher matcher = CIDR_PATTERN.matcher(cidr);
        if (!matcher.matches()) {
            throw new CidrParseException("Syntax error in input CIDR: " + cidr);
        }
        try {
            int prefix = 0;
            for (int i = 1; i < 5; ++i) {
                int component = Integer.parseInt(matcher.group(i));
                if (component > 255) {
                    throw new CidrParseException("Component value larger than 255: " + cidr);
                }
                prefix = (prefix << 8) + component;
            }
            int mask = 0;
            if (matcher.group(5) != null) {
                mask = Integer.parseInt(matcher.group(5));
                if (mask > 32) {
                    throw new CidrParseException("Prefix length larger than 32: " + cidr);
                }
                mask = mask == 0 ? -1 : (1 << 32 - mask) - 1;
            }
            if (prefix & mask) {
                throw new CidrParseException("Address and prefix length do not match: " + cidr);
            }
            return new Cidr(prefix, ~mask);
        }
        catch (NumberFormatException e) {
            throw new CidrParseException("Impossible number format error: " + cidr);
        }
    }

    public static void main(String[] args) throws Exception {
        String ip = "192.168.0.0/16";
        System.out.println(ip + "->" + Cidr.valueOf(ip).toString());
        ip = "192.168.1.0/32";
        System.out.println(ip + "->" + Cidr.valueOf(ip).toString());
        ip = "0.0.0.0/0";
        System.out.println(ip + "->" + Cidr.valueOf(ip).toString());
        System.out.println(Cidr.valueOf("192.168.0.0/16").matchIp("192.168.0.1"));
        System.out.println(Cidr.valueOf("192.168.0.0/16").matchIp("192.169.0.1"));
        System.out.println(Cidr.valueOf("0.0.0.0/0").matchIp("192.168.0.1"));
        System.out.println(Cidr.valueOf("192.168.0.1/32").matchIp("192.168.0.1"));
    }
}

