/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth.policy.key;

import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.policy.key.Key;
import com.eucalyptus.auth.policy.key.PolicyKey;
import com.eucalyptus.system.Ats;
import com.google.common.collect.Maps;
import java.util.Map;

public class CachedKeyEvaluator {
    private final Map<String, String> evaluatedKeys;
    private final Map<Class<? extends Key>, String> cache = Maps.newHashMap();

    public CachedKeyEvaluator(Map<String, String> evaluatedKeys) {
        this.evaluatedKeys = evaluatedKeys;
    }

    public String getValue(Key key) throws AuthException {
        String value = this.cache.get(key.getClass());
        if (value == null) {
            PolicyKey policyKey = (PolicyKey)Ats.from(key.getClass()).get(PolicyKey.class);
            String string = value = policyKey == null ? null : this.evaluatedKeys.get(policyKey.value());
            if (value == null) {
                value = key.value();
            }
            this.cache.put(key.getClass(), value);
        }
        return value;
    }
}

