/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth.policy.condition;

import com.eucalyptus.auth.policy.condition.NumericConditionOp;
import com.eucalyptus.auth.policy.condition.NumericEquals;
import com.eucalyptus.auth.policy.condition.PolicyCondition;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

@PolicyCondition(value={"NumericGreaterThanEquals", "numgteq"})
public class NumericGreaterThanEquals
implements NumericConditionOp {
    private static final Logger LOG = Logger.getLogger(NumericEquals.class);

    public boolean check(@Nullable String key, String value) {
        try {
            return key != null && Integer.valueOf(key).compareTo(Integer.valueOf(value)) >= 0;
        }
        catch (NumberFormatException e) {
            try {
                return Double.valueOf(key).compareTo(Double.valueOf(value)) >= 0;
            }
            catch (NumberFormatException e1) {
                LOG.error((Object)"Invalid number format", (Throwable)e1);
                return false;
            }
        }
    }
}

