/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth.policy.condition;

import com.eucalyptus.auth.policy.condition.AddressConditionOp;
import com.eucalyptus.auth.policy.condition.IpAddress;
import com.eucalyptus.auth.policy.condition.PolicyCondition;
import com.eucalyptus.auth.policy.key.Cidr;
import com.eucalyptus.auth.policy.key.CidrParseException;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

@PolicyCondition(value={"NotIpAddress"})
public class NotIpAddress
implements AddressConditionOp {
    private static final Logger LOG = Logger.getLogger(IpAddress.class);

    public boolean check(@Nullable String key, String value) {
        try {
            return key == null || !Cidr.valueOf(value).matchIp(key);
        }
        catch (CidrParseException e) {
            LOG.error((Object)("Invalid IP address and CIDR: " + key + ", " + value), (Throwable)e);
            return false;
        }
    }
}

