/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth.policy.condition;

import com.eucalyptus.auth.policy.PatternUtils;
import com.eucalyptus.auth.policy.condition.ArnConditionOp;
import com.eucalyptus.auth.policy.condition.PolicyCondition;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

@PolicyCondition(value={"ArnLike"})
public class ArnLikeConditionOp
implements ArnConditionOp {
    static final String NAME = "ArnLike";
    static final Splitter arnSplitter = Splitter.on((char)':').limit(6);

    public boolean check(@Nullable String key, String value) {
        return key != null && value != null && ArnLikeConditionOp.matchesLike(value, key);
    }

    static boolean matchesLike(String arnPattern, String arn) {
        boolean matches = true;
        ArrayList arnPatternParts = Lists.newArrayList((Iterable)arnSplitter.split((CharSequence)arnPattern));
        ArrayList arnParts = Lists.newArrayList((Iterable)arnSplitter.split((CharSequence)arn));
        if (arnPatternParts.size() == 6 & arnParts.size() == 6) {
            for (int i = 0; i < 6; ++i) {
                String arnPatternPart = ((String)arnPatternParts.get(i)).toLowerCase();
                String arnPart = ((String)arnParts.get(i)).toLowerCase();
                String pattern = PatternUtils.toJavaPattern(arnPatternPart);
                if (Pattern.matches(pattern, arnPart)) continue;
                matches = false;
                break;
            }
        } else {
            matches = false;
        }
        return matches;
    }
}

