/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth.policy;

import com.eucalyptus.auth.Accounts;
import com.eucalyptus.auth.AuthEvaluationContext;
import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.Contract;
import com.eucalyptus.auth.api.PolicyEngine;
import com.eucalyptus.auth.policy.AuthorizationProviders;
import com.eucalyptus.auth.policy.PatternUtils;
import com.eucalyptus.auth.policy.PolicySpec;
import com.eucalyptus.auth.policy.condition.ConditionOp;
import com.eucalyptus.auth.policy.condition.Conditions;
import com.eucalyptus.auth.policy.condition.NumericGreaterThan;
import com.eucalyptus.auth.policy.ern.AddressUtil;
import com.eucalyptus.auth.policy.key.CachedKeyEvaluator;
import com.eucalyptus.auth.policy.key.ContractKey;
import com.eucalyptus.auth.policy.key.ContractKeyEvaluator;
import com.eucalyptus.auth.policy.key.Key;
import com.eucalyptus.auth.policy.key.Keys;
import com.eucalyptus.auth.policy.key.QuotaKey;
import com.eucalyptus.auth.principal.Account;
import com.eucalyptus.auth.principal.Authorization;
import com.eucalyptus.auth.principal.Condition;
import com.eucalyptus.auth.principal.Policy;
import com.eucalyptus.auth.principal.Principal;
import com.eucalyptus.auth.principal.User;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.Parameters;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.hamcrest.Matchers;

public class PolicyEngineImpl
implements PolicyEngine {
    private static final Logger LOG = Logger.getLogger(PolicyEngineImpl.class);
    @Nonnull
    private final Function<String, String> accountResolver;
    @Nonnull
    private final Supplier<Boolean> enableSystemQuotas;
    private static final Matcher PATTERN_MATCHER = new Matcher(){

        @Override
        public boolean match(String pattern, String instance) {
            if ((pattern = PatternUtils.toJavaPattern(pattern)) == null) {
                return false;
            }
            return Pattern.matches(pattern, instance);
        }
    };
    private static final Matcher ADDRESS_MATCHER = new Matcher(){

        @Override
        public boolean match(String pattern, String instance) {
            if (pattern == null) {
                return false;
            }
            return AddressUtil.addressRangeMatch((String)pattern, (String)instance);
        }
    };
    private static final Matcher SERVER_CERTIFICATE_MATCHER = new Matcher(){

        @Override
        public boolean match(String pattern, String instance) {
            if (pattern == null) {
                return false;
            }
            if (!instance.startsWith("arn:aws:iam::")) {
                return false;
            }
            int idx = instance.indexOf(":server-certificate");
            if (idx < 0) {
                return false;
            }
            if ((idx += ":server-certificate".length()) >= instance.length()) {
                return false;
            }
            String certPathAndName = instance.substring(idx);
            return Pattern.matches(pattern, certPathAndName);
        }
    };

    public PolicyEngineImpl(@Nonnull Supplier<Boolean> enableSystemQuotas) {
        this(DefaultAccountResolver.INSTANCE, enableSystemQuotas);
    }

    public PolicyEngineImpl(@Nonnull Function<String, String> accountResolver, @Nonnull Supplier<Boolean> enableSystemQuotas) {
        this.accountResolver = (Function)Parameters.checkParam((String)"accountResolver", accountResolver, (org.hamcrest.Matcher)Matchers.notNullValue());
        this.enableSystemQuotas = (Supplier)Parameters.checkParam((String)"enableSystemQuotas", enableSystemQuotas, (org.hamcrest.Matcher)Matchers.notNullValue());
    }

    public void evaluateAuthorization(@Nonnull AuthEvaluationContext context, @Nonnull PolicyEngine.AuthorizationMatch authorizationMatch, @Nullable String resourceAccountNumber, @Nonnull String resourceName, @Nonnull Map<Contract.Type, Contract> contracts) throws AuthException {
        try {
            if (Decision.ALLOW != this.evaluateResourceAuthorization(context, authorizationMatch, resourceAccountNumber, resourceName, contracts)) {
                throw new AuthException("Access to the resource is denied");
            }
        }
        catch (AuthException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AuthException("An error occurred while trying to evaluate policy for resource access", (Throwable)e);
        }
    }

    public void evaluateAuthorization(@Nonnull AuthEvaluationContext context, @Nullable Policy resourcePolicy, @Nullable String resourceAccountNumber, @Nonnull String resourceName, @Nonnull Map<Contract.Type, Contract> contracts) throws AuthException {
        try {
            AuthEvaluationContextImpl evaluationContext = (AuthEvaluationContextImpl)context;
            ContractKeyEvaluator contractEval = new ContractKeyEvaluator(contracts);
            CachedKeyEvaluator keyEval = new CachedKeyEvaluator(context.getEvaluatedKeys());
            String action = evaluationContext.getAction();
            User requestUser = evaluationContext.getRequestUser();
            if (!evaluationContext.isSystemAdmin()) {
                this.verifyUser(requestUser);
                Account account = evaluationContext.getRequestAccount();
                if (!requestUser.isAccountAdmin() || resourceAccountNumber == null || !resourceAccountNumber.equals(account.getAccountNumber())) {
                    Decision decision;
                    Decision decision2 = decision = resourcePolicy == null ? Decision.ALLOW : this.processAuthorizations(resourcePolicy.getAuthorizations(), PolicyEngine.AuthorizationMatch.All, action, null, null, evaluationContext.getPrincipalType(), evaluationContext.getPrincipalName(), keyEval, contractEval);
                    if (decision != Decision.ALLOW) {
                        LOG.debug((Object)("Request is rejected by resource authorization check, due to decision " + (Object)((Object)decision)));
                        throw new AuthException("Access to the resource is denied");
                    }
                    decision = this.evaluateResourceAuthorization(evaluationContext, PolicyEngine.AuthorizationMatch.All, resourceAccountNumber, resourceName, contracts);
                    if (Decision.DENY == decision || Decision.ALLOW != decision && resourcePolicy == null) {
                        throw new AuthException("Access to the resource is denied");
                    }
                }
            }
        }
        catch (AuthException e) {
            LOG.debug((Object)e, (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LOG.debug((Object)e, (Throwable)e);
            throw new AuthException("An error occurred while trying to evaluate policy for resource access", (Throwable)e);
        }
    }

    public void evaluateQuota(@Nonnull AuthEvaluationContext context, @Nonnull String resourceName, @Nonnull Long quantity) throws AuthException {
        try {
            AuthEvaluationContextImpl evaluationContext = (AuthEvaluationContextImpl)context;
            User requestUser = context.getRequestUser();
            String resourceType = context.getResourceType();
            resourceName = PolicySpec.canonicalizeResourceName((String)resourceType, (String)resourceName);
            String action = context.getAction().toLowerCase();
            if (!evaluationContext.isSystemUser() || ((Boolean)this.enableSystemQuotas.get()).booleanValue()) {
                List<Authorization> quotas = PolicyEngineImpl.lookupQuotas(resourceType, requestUser, evaluationContext.getRequestAccount());
                this.processQuotas(quotas, action, resourceType, resourceName, quantity);
            }
        }
        catch (AuthException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AuthException("An error occurred while trying to evaluate policy for resource allocation.", (Throwable)e);
        }
    }

    public AuthEvaluationContext createEvaluationContext(String resourceType, String action, User requestUser, Map<String, String> evaluatedKeys) {
        return new AuthEvaluationContextImpl(resourceType, action, requestUser, evaluatedKeys);
    }

    public AuthEvaluationContext createEvaluationContext(String resourceType, String action, User requestUser, Map<String, String> evaluatedKeys, Principal.PrincipalType principalType, String principalName) {
        return new AuthEvaluationContextImpl(resourceType, action, requestUser, evaluatedKeys, principalType, principalName);
    }

    private Decision evaluateResourceAuthorization(@Nonnull AuthEvaluationContext context, @Nonnull PolicyEngine.AuthorizationMatch authorizationMatch, @Nullable String resourceAccountNumber, @Nonnull String resourceName, @Nonnull Map<Contract.Type, Contract> contracts) throws AuthException {
        AuthEvaluationContextImpl evaluationContext = (AuthEvaluationContextImpl)context;
        ContractKeyEvaluator contractEval = new ContractKeyEvaluator(contracts);
        CachedKeyEvaluator keyEval = new CachedKeyEvaluator(context.getEvaluatedKeys());
        String action = evaluationContext.getAction();
        User requestUser = evaluationContext.getRequestUser();
        String resourceType = evaluationContext.getResourceType();
        resourceName = PolicySpec.canonicalizeResourceName((String)resourceType, (String)resourceName);
        if (evaluationContext.isSystemAdmin()) {
            return Decision.ALLOW;
        }
        this.verifyUser(requestUser);
        Account account = evaluationContext.getRequestAccount();
        Decision decision = this.processAuthorizations(evaluationContext.lookupGlobalAuthorizations(), authorizationMatch, action, resourceAccountNumber, resourceName, keyEval, contractEval);
        if (decision == Decision.DENY) {
            LOG.debug((Object)("Request is rejected by global authorization check, due to decision " + (Object)((Object)decision)));
            return decision;
        }
        if (resourceAccountNumber != null && !resourceAccountNumber.equals(account.getAccountNumber()) && !evaluationContext.isSystemUser()) {
            decision = this.processAuthorizations(evaluationContext.lookupLocalAuthorizations(), authorizationMatch, action, resourceAccountNumber, resourceName, keyEval, contractEval);
            if (decision == Decision.DENY) {
                LOG.debug((Object)("Request is rejected by local authorization check, due to decision " + (Object)((Object)decision)));
            }
            return decision == Decision.ALLOW ? Decision.DEFAULT : decision;
        }
        if (requestUser.isAccountAdmin()) {
            return Decision.ALLOW;
        }
        decision = this.processAuthorizations(evaluationContext.lookupLocalAuthorizations(), authorizationMatch, action, resourceAccountNumber, resourceName, keyEval, contractEval);
        if (decision == Decision.DENY || decision == Decision.DEFAULT) {
            LOG.debug((Object)("Request is rejected by local authorization check, due to decision " + (Object)((Object)decision)));
        }
        return decision;
    }

    private void verifyUser(User requestUser) throws AuthException {
        if (!requestUser.isEnabled().booleanValue() || !User.RegistrationStatus.CONFIRMED.equals((Object)requestUser.getRegistrationStatus())) {
            LOG.debug((Object)"Request user is rejected because he/she is not enabled or confirmed yet");
            throw new AuthException("Access to the resource is denied");
        }
    }

    private Decision processAuthorizations(List<Authorization> authorizations, PolicyEngine.AuthorizationMatch authorizationMatch, String action, String resourceAccountNumber, String resource, CachedKeyEvaluator keyEval, ContractKeyEvaluator contractEval) throws AuthException {
        return this.processAuthorizations(authorizations, authorizationMatch, action, resourceAccountNumber, resource, null, null, keyEval, contractEval);
    }

    private Decision processAuthorizations(@Nonnull List<Authorization> authorizations, @Nonnull PolicyEngine.AuthorizationMatch authorizationMatch, @Nonnull String action, @Nullable String resourceAccountNumber, @Nullable String resource, @Nullable Principal.PrincipalType principalType, @Nullable String principalName, @Nonnull CachedKeyEvaluator keyEval, @Nonnull ContractKeyEvaluator contractEval) throws AuthException {
        Decision result = Decision.DEFAULT;
        for (Authorization auth : authorizations) {
            if (!this.matchActions(auth, action) || !this.matchPrincipal(auth.getPrincipal(), principalType, principalName)) continue;
            if (authorizationMatch == PolicyEngine.AuthorizationMatch.Unconditional && auth.getEffect() == Authorization.EffectType.Allow) {
                return Decision.ALLOW;
            }
            if (!this.matchResources(auth, resourceAccountNumber, resource) || !this.evaluateConditions(auth.getConditions(), action, auth.getType(), keyEval, contractEval)) continue;
            if (auth.getEffect() == Authorization.EffectType.Deny) {
                return Decision.DENY;
            }
            result = Decision.ALLOW;
        }
        return result;
    }

    private boolean matchActions(Authorization auth, String action) throws AuthException {
        return this.evaluateElement(PolicyEngineImpl.matchOne(auth.getActions(), action, PATTERN_MATCHER), auth.isNotAction());
    }

    private boolean matchPrincipal(Principal principal, Principal.PrincipalType principalType, String principalName) throws AuthException {
        return principalName == null || principal != null && principal.getType() == principalType && this.evaluateElement(PolicyEngineImpl.matchOne(principalType.convertForUserMatching(principal.getValues()), principalName, PATTERN_MATCHER), principal.isNotPrincipal());
    }

    private boolean matchResources(Authorization auth, String resource) throws AuthException {
        return this.matchResources(auth, null, resource);
    }

    private boolean matchResources(@Nonnull Authorization auth, @Nullable String resourceAccountNumber, @Nullable String resource) throws AuthException {
        if (resource == null) {
            return true;
        }
        if (auth.getAccount() != null && resourceAccountNumber != null && !this.resolveAccount(auth.getAccount()).equals(resourceAccountNumber)) {
            return auth.isNotResource();
        }
        if ("address".equals(auth.getType())) {
            return this.evaluateElement(PolicyEngineImpl.matchOne(auth.getResources(), resource, ADDRESS_MATCHER), auth.isNotResource());
        }
        if (String.format("%s:%s", "iam", "server-certificate").equals(auth.getType())) {
            return this.evaluateElement(PolicyEngineImpl.matchOne(auth.getResources(), resource, SERVER_CERTIFICATE_MATCHER), auth.isNotResource());
        }
        return this.evaluateElement(PolicyEngineImpl.matchOne(auth.getResources(), resource, PATTERN_MATCHER), auth.isNotResource());
    }

    private static boolean matchOne(Set<String> patterns, String instance, Matcher matcher) {
        for (String pattern : patterns) {
            if (!matcher.match(pattern, instance)) continue;
            return true;
        }
        return false;
    }

    private String resolveAccount(String accountNumberOrAlias) {
        return (String)this.accountResolver.apply((Object)accountNumberOrAlias);
    }

    private boolean evaluateElement(boolean patternMatched, boolean isNot) {
        return patternMatched && !isNot || !patternMatched && isNot;
    }

    private boolean evaluateConditions(List<? extends Condition> conditions, String action, String resourceType, CachedKeyEvaluator keyEval, ContractKeyEvaluator contractEval) throws AuthException {
        for (Condition condition : conditions) {
            ConditionOp op = Conditions.getOpInstance((String)condition.getType());
            Key key = Keys.getKeyInstance((Class)Keys.getKeyClass((String)condition.getKey()));
            boolean applies = key.canApply(action, resourceType);
            if (key instanceof ContractKey) {
                if (!applies) continue;
                contractEval.addContract((ContractKey)key, condition.getValues());
                continue;
            }
            boolean condValue = false;
            Iterator i$ = condition.getValues().iterator();
            while (i$.hasNext()) {
                String value;
                if (!op.check(applies ? keyEval.getValue(key) : null, value = (String)i$.next())) continue;
                condValue = true;
                break;
            }
            if (condValue) continue;
            return false;
        }
        return true;
    }

    private static List<Authorization> lookupGlobalAuthorizations(String resourceType, Account account) throws AuthException {
        ArrayList results = Lists.newArrayList();
        results.addAll(account.lookupAccountGlobalAuthorizations(resourceType));
        if (!"*".equals(resourceType)) {
            results.addAll(account.lookupAccountGlobalAuthorizations("*"));
        }
        return results;
    }

    private static List<Authorization> lookupLocalAuthorizations(String resourceType, User user) throws AuthException {
        ArrayList results = Lists.newArrayList();
        results.addAll(user.lookupAuthorizations(resourceType));
        if (resourceType != null && resourceType.contains(":") && !resourceType.endsWith(":*")) {
            results.addAll(user.lookupAuthorizations(resourceType.substring(0, resourceType.indexOf(58)) + ":*"));
        }
        if (resourceType != null && !"*".equals(resourceType)) {
            results.addAll(user.lookupAuthorizations("*"));
        }
        return results;
    }

    private static List<Authorization> lookupQuotas(String resourceType, User user, Account account) throws AuthException {
        return AuthorizationProviders.lookupQuotas(account, user, resourceType);
    }

    private void processQuotas(List<Authorization> quotas, String action, String resourceType, String resourceName, Long quantity) throws AuthException {
        NumericGreaterThan ngt = new NumericGreaterThan();
        for (Authorization auth : quotas) {
            if (!this.matchActions(auth, action)) {
                LOG.debug((Object)("Action " + action + " not matching"));
                continue;
            }
            if (!this.matchResources(auth, resourceName)) {
                LOG.debug((Object)("Resource " + resourceName + " not matching"));
                continue;
            }
            Authorization.Scope scope = this.getAuthorizationScope(auth);
            String principalId = this.getAuthorizationPrincipalId(auth);
            for (Condition cond : auth.getConditions()) {
                Key key = Keys.getKeyInstance((Class)Keys.getKeyClass((String)cond.getKey()));
                if (!(key instanceof QuotaKey)) {
                    LOG.debug((Object)("Key " + cond.getKey() + " is not a quota"));
                    continue;
                }
                QuotaKey quotaKey = (QuotaKey)key;
                if (!key.canApply(action, resourceType)) {
                    LOG.debug((Object)("Key " + cond.getKey() + " can not apply for action=" + action + ", resourceType=" + resourceType));
                    continue;
                }
                String usageValue = quotaKey.value(scope, principalId, resourceName, quantity);
                if ("Not supported".equals(usageValue)) {
                    LOG.debug((Object)("Key " + cond.getKey() + " is not supported for scope=" + scope));
                    continue;
                }
                String quotaValue = (String)Iterables.getFirst((Iterable)cond.getValues(), null);
                if (!ngt.check(usageValue, quotaValue)) continue;
                LOG.error((Object)("Quota " + key.getClass().getName() + " is exceeded: quota=" + quotaValue + ", usage=" + usageValue));
                throw new AuthException("Resource quota is exceeded");
            }
        }
    }

    private String getAuthorizationPrincipalId(Authorization auth) throws AuthException {
        return auth.getScopeId();
    }

    private Authorization.Scope getAuthorizationScope(Authorization auth) throws AuthException {
        return auth.getScope();
    }

    private static enum DefaultAccountResolver implements Function<String, String>
    {
        INSTANCE;

        private static final Supplier<String> eucalyptusAccountNumberSupplier;

        public String apply(String accountNumberOrAlias) {
            if ("eucalyptus".equals(accountNumberOrAlias)) {
                return (String)eucalyptusAccountNumberSupplier.get();
            }
            return accountNumberOrAlias;
        }

        static {
            eucalyptusAccountNumberSupplier = Suppliers.memoize((Supplier)EucalyptusAccountNumberSupplier.INSTANCE);
        }
    }

    private static enum EucalyptusAccountNumberSupplier implements Supplier<String>
    {
        INSTANCE;


        public String get() {
            try {
                return Accounts.lookupAccountByName((String)"eucalyptus").getAccountNumber();
            }
            catch (AuthException e) {
                throw Exceptions.toUndeclared((Throwable)e);
            }
        }
    }

    private static enum CachedConditionTransform implements Function<Condition, Condition>
    {
        INSTANCE;


        public Condition apply(Condition condition) {
            return new CachedDelegatingCondition(condition);
        }
    }

    private static enum CachedAuthorizationTransform implements Function<Authorization, Authorization>
    {
        INSTANCE;


        public Authorization apply(Authorization authorization) {
            return new CachedDelegatingAuthorization(authorization);
        }
    }

    private static class CachedDelegatingCondition
    implements Condition {
        private static final long serialVersionUID = 1L;
        private final Condition delegate;
        private Set<String> values;

        private CachedDelegatingCondition(Condition delegate) {
            this.delegate = delegate;
        }

        public String getKey() {
            return this.delegate.getKey();
        }

        public String getType() {
            return this.delegate.getType();
        }

        public Set<String> getValues() throws AuthException {
            if (this.values == null) {
                this.values = this.delegate.getValues();
            }
            return this.values;
        }
    }

    private static final class CachedDelegatingAuthorization
    implements Authorization {
        private static final long serialVersionUID = 1L;
        private final Authorization delegate;
        private Set<String> actions;
        private List<Condition> conditions;
        private Set<String> resource;
        private Principal principal;

        private CachedDelegatingAuthorization(Authorization delegate) {
            this.delegate = delegate;
        }

        public Set<String> getActions() throws AuthException {
            if (this.actions == null) {
                this.actions = ImmutableSet.copyOf((Collection)this.delegate.getActions());
            }
            return this.actions;
        }

        public List<Condition> getConditions() throws AuthException {
            if (this.conditions == null) {
                this.conditions = ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)this.delegate.getConditions(), (Function)CachedConditionTransform.INSTANCE));
            }
            return this.conditions;
        }

        public Set<String> getResources() throws AuthException {
            if (this.resource == null) {
                this.resource = ImmutableSet.copyOf((Collection)this.delegate.getResources());
            }
            return this.resource;
        }

        public String getAccount() {
            return this.delegate.getAccount();
        }

        public String getType() {
            return this.delegate.getType();
        }

        public Principal getPrincipal() throws AuthException {
            if (this.principal == null) {
                this.principal = this.delegate.getPrincipal();
            }
            return this.principal;
        }

        public Boolean isNotResource() {
            return this.delegate.isNotResource();
        }

        public Boolean isNotAction() {
            return this.delegate.isNotAction();
        }

        public Authorization.Scope getScope() throws AuthException {
            return this.delegate.getScope();
        }

        public String getScopeId() throws AuthException {
            return this.delegate.getScopeId();
        }

        public Authorization.EffectType getEffect() {
            return this.delegate.getEffect();
        }
    }

    static class AuthEvaluationContextImpl
    implements AuthEvaluationContext {
        @Nullable
        private final String resourceType;
        private final String action;
        private final User requestUser;
        @Nullable
        private final Principal.PrincipalType principalType;
        @Nullable
        private final String principalName;
        private Account requestAccount;
        private Boolean systemAdmin;
        private Boolean systemUser;
        private Map<String, String> evaluatedKeys;
        private List<Authorization> globalAuthorizations;
        private List<Authorization> localAuthorizations;

        AuthEvaluationContextImpl(@Nullable String resourceType, String action, User requestUser, Map<String, String> evaluatedKeys) {
            this(resourceType, action, requestUser, evaluatedKeys, null, null);
        }

        AuthEvaluationContextImpl(@Nullable String resourceType, String action, User requestUser, Map<String, String> evaluatedKeys, @Nullable Principal.PrincipalType principalType, @Nullable String principalName) {
            this.resourceType = resourceType;
            this.action = action.toLowerCase();
            this.evaluatedKeys = ImmutableMap.copyOf(evaluatedKeys);
            this.requestUser = requestUser;
            this.principalType = principalType;
            this.principalName = principalName;
        }

        @Nullable
        public String getResourceType() {
            return this.resourceType;
        }

        public String getAction() {
            return this.action;
        }

        public User getRequestUser() {
            return this.requestUser;
        }

        public Map<String, String> getEvaluatedKeys() {
            return this.evaluatedKeys;
        }

        @Nullable
        public Principal.PrincipalType getPrincipalType() {
            return this.principalType;
        }

        @Nullable
        public String getPrincipalName() {
            return this.principalName;
        }

        public String describe(String resourceAccountNumber, String resourceName) {
            return String.valueOf(this.resourceType) + ":" + resourceName + (resourceAccountNumber == null ? "" : " of " + resourceAccountNumber) + " for " + this.describePrincipal();
        }

        public String describe(String resourceName, Long quantity) {
            return String.valueOf(this.resourceType) + ":" + resourceName + " by " + quantity + " for " + this.describePrincipal();
        }

        private String describePrincipal() {
            return this.principalType != null && this.principalName != null ? this.principalType + ":" + this.principalName + " / " + this.requestUser : String.valueOf(this.requestUser);
        }

        Account getRequestAccount() throws AuthException {
            if (this.requestAccount == null) {
                this.requestAccount = this.requestUser.getAccount();
            }
            return this.requestAccount;
        }

        boolean isSystemAdmin() {
            if (this.systemAdmin == null) {
                this.systemAdmin = this.requestUser.isSystemAdmin();
            }
            return this.systemAdmin;
        }

        boolean isSystemUser() {
            if (this.systemUser == null) {
                this.systemUser = this.requestUser.isSystemUser();
            }
            return this.systemUser;
        }

        public List<Authorization> lookupGlobalAuthorizations() throws AuthException {
            if (this.globalAuthorizations == null) {
                this.globalAuthorizations = this.resourceType != null ? this.cached(PolicyEngineImpl.lookupGlobalAuthorizations(this.resourceType, this.getRequestAccount())) : Collections.emptyList();
            }
            return this.globalAuthorizations;
        }

        public List<Authorization> lookupLocalAuthorizations() throws AuthException {
            if (this.localAuthorizations == null) {
                this.localAuthorizations = this.cached(PolicyEngineImpl.lookupLocalAuthorizations(this.resourceType, this.getRequestUser()));
            }
            return this.localAuthorizations;
        }

        private List<Authorization> cached(List<Authorization> authorizations) {
            return ImmutableList.copyOf((Iterable)Iterables.transform(authorizations, (Function)CachedAuthorizationTransform.INSTANCE));
        }
    }

    private static interface Matcher {
        public boolean match(String var1, String var2);
    }

    private static enum Decision {
        DEFAULT,
        DENY,
        ALLOW;

    }
}

