/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth.policy;

import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.policy.AuthorizationProvider;
import com.eucalyptus.auth.principal.Account;
import com.eucalyptus.auth.principal.Authorization;
import com.eucalyptus.auth.principal.User;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

class AuthorizationProviders {
    private static CopyOnWriteArrayList<AuthorizationProvider> providers = new CopyOnWriteArrayList();

    AuthorizationProviders() {
    }

    static List<Authorization> lookupQuotas(Account account, User user, String resourceType) throws AuthException {
        ArrayList authorizations = Lists.newArrayList();
        for (AuthorizationProvider provider : providers) {
            authorizations.addAll(provider.lookupQuotas(account, user, resourceType));
        }
        return authorizations;
    }

    static void register(AuthorizationProvider provider) {
        providers.add(provider);
    }
}

