/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth.policy;

import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.policy.AuthorizationProvider;
import com.eucalyptus.auth.principal.Account;
import com.eucalyptus.auth.principal.Authorization;
import com.eucalyptus.auth.principal.Condition;
import com.eucalyptus.auth.principal.Principal;
import com.eucalyptus.auth.principal.User;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class AuthorizationProviderSupport
implements AuthorizationProvider {
    @Override
    public List<Authorization> lookupQuotas(Account account, User user, String resourceType) throws AuthException {
        return Collections.emptyList();
    }

    public static final class QuotaAuthorization
    implements Authorization {
        private static final long serialVersionUID = 1L;
        private final String accountNumber;
        private final String userId;
        private final String resourceType;
        private final Condition condition;

        public QuotaAuthorization(String accountNumber, String userId, String resourceType, Condition condition) {
            this.accountNumber = accountNumber;
            this.userId = userId;
            this.resourceType = resourceType;
            this.condition = condition;
        }

        public Authorization.EffectType getEffect() {
            return Authorization.EffectType.Limit;
        }

        public String getAccount() {
            return this.accountNumber;
        }

        public String getType() {
            return this.resourceType;
        }

        public Boolean isNotAction() {
            return Boolean.FALSE;
        }

        public Set<String> getActions() throws AuthException {
            return Collections.singleton("*");
        }

        public Boolean isNotResource() {
            return Boolean.FALSE;
        }

        public Set<String> getResources() throws AuthException {
            return Collections.singleton("*");
        }

        public List<Condition> getConditions() throws AuthException {
            return Collections.singletonList(this.condition);
        }

        public Authorization.Scope getScope() throws AuthException {
            return Authorization.Scope.USER;
        }

        public String getScopeId() throws AuthException {
            return this.userId;
        }

        public Principal getPrincipal() {
            return null;
        }
    }

    public static final class QuotaCondition
    implements Condition {
        private static final long serialVersionUID = 1L;
        private final String key;
        private final String value;

        public QuotaCondition(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getType() {
            return "NumericLessThanEquals";
        }

        public String getKey() {
            return this.key;
        }

        public Set<String> getValues() throws AuthException {
            return Collections.singleton(this.value);
        }
    }
}

