/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth.login;

import com.eucalyptus.auth.Accounts;
import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.PasswordAuthentication;
import com.eucalyptus.auth.api.BaseLoginModule;
import com.eucalyptus.auth.login.AccountUsernamePasswordCredentials;
import com.eucalyptus.auth.principal.Account;
import com.eucalyptus.auth.principal.User;
import javax.security.auth.login.FailedLoginException;

public class PasswordLoginModule
extends BaseLoginModule<AccountUsernamePasswordCredentials> {
    public boolean accepts() {
        return super.getCallbackHandler() instanceof AccountUsernamePasswordCredentials;
    }

    public boolean authenticate(AccountUsernamePasswordCredentials credentials) throws Exception {
        User user;
        String accountName = credentials.getAccount();
        String username = credentials.getUsername();
        String password = credentials.getPassword();
        String newPassword = credentials.getNewPassword();
        try {
            Account account = Accounts.lookupAccountByName((String)accountName);
            user = account.lookupUserByName(username);
        }
        catch (AuthException e) {
            throw new FailedLoginException();
        }
        PasswordAuthentication.authenticate(user, password, newPassword);
        super.setCredential((Object)credentials.getAccountUsername());
        super.setPrincipal(user);
        return true;
    }
}

