/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth.ldap.authentication;

import com.eucalyptus.auth.LdapException;
import com.eucalyptus.auth.ldap.authentication.EasySSLSocketFactory;
import com.eucalyptus.auth.ldap.authentication.LdapAuthenticator;
import com.google.common.base.Strings;
import java.io.IOException;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.log4j.Logger;

public class GssapiKrb5Authenticator
implements LdapAuthenticator {
    public static final String KRB5_CONF_PROPERTY = "java.security.krb5.conf";
    public static final String KRB5_LOGIN_MODULE = "com.sun.security.auth.module.Krb5LoginModule";
    public static final String JAAS_CONF_OPTION_CLIENT = "client";
    public static final String KRB5_LOGIN_CONTEXT_NAME = GssapiKrb5Authenticator.class.getName();
    private static final Logger LOG = Logger.getLogger(GssapiKrb5Authenticator.class);

    @Override
    public LdapContext authenticate(final String serverUrl, String method, final boolean useSsl, final boolean ignoreSslCert, final String login, final String password, Object ... extraArgs) throws LdapException {
        if (Strings.isNullOrEmpty((String)login) || Strings.isNullOrEmpty((String)password)) {
            throw new LdapException("LDAP login failed: empty login name or password");
        }
        if (extraArgs.length < 1 || !(extraArgs[0] instanceof String) || Strings.isNullOrEmpty((String)((String)extraArgs[0]))) {
            throw new LdapException("GSSAPI w/ Kerberos V5 requires krb5.conf argument");
        }
        System.setProperty(KRB5_CONF_PROPERTY, (String)extraArgs[0]);
        final HashMap<String, String> options = new HashMap<String, String>();
        options.put(JAAS_CONF_OPTION_CLIENT, "TRUE");
        Configuration configuration = new Configuration(){

            @Override
            public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
                return new AppConfigurationEntry[]{new AppConfigurationEntry(GssapiKrb5Authenticator.KRB5_LOGIN_MODULE, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options)};
            }
        };
        CallbackHandler callbackHandler = new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                for (int i = 0; i < callbacks.length; ++i) {
                    Callback cb;
                    if (callbacks[i] instanceof NameCallback) {
                        cb = (NameCallback)callbacks[i];
                        ((NameCallback)cb).setName(login);
                        continue;
                    }
                    if (!(callbacks[i] instanceof PasswordCallback)) continue;
                    cb = (PasswordCallback)callbacks[i];
                    char[] pwBytes = new char[password.length()];
                    password.getChars(0, pwBytes.length, pwBytes, 0);
                    ((PasswordCallback)cb).setPassword(pwBytes);
                }
            }
        };
        LoginContext loginContext = null;
        try {
            loginContext = new LoginContext(KRB5_LOGIN_CONTEXT_NAME, null, callbackHandler, configuration);
            loginContext.login();
        }
        catch (LoginException e) {
            LOG.error((Object)e, (Throwable)e);
            throw new LdapException("Failed to login to Kerberos", (Throwable)e);
        }
        LdapContext ldapContext = Subject.doAs(loginContext.getSubject(), new PrivilegedAction<LdapContext>(){

            @Override
            public LdapContext run() {
                Properties env = new Properties();
                env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
                env.put("java.naming.referral", "follow");
                env.put("java.naming.provider.url", serverUrl);
                env.put("java.naming.security.authentication", "GSSAPI");
                if (useSsl) {
                    env.put("java.naming.security.protocol", "ssl");
                    if (ignoreSslCert) {
                        env.put("java.naming.ldap.factory.socket", EasySSLSocketFactory.class.getCanonicalName());
                    }
                }
                try {
                    return new InitialLdapContext(env, null);
                }
                catch (NamingException e) {
                    LOG.error((Object)e, (Throwable)e);
                    return null;
                }
            }
        });
        if (ldapContext == null) {
            throw new LdapException("LDAP login failed, possibly wrong credential");
        }
        return ldapContext;
    }
}

