/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth.ldap.authentication;

import com.eucalyptus.auth.LdapException;
import com.eucalyptus.auth.ldap.authentication.EasySSLSocketFactory;
import com.eucalyptus.auth.ldap.authentication.LdapAuthenticator;
import com.google.common.base.Strings;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import org.apache.log4j.Logger;

public class DefaultAuthenticator
implements LdapAuthenticator {
    private static Logger LOG = Logger.getLogger(DefaultAuthenticator.class);

    @Override
    public LdapContext authenticate(String serverUrl, String method, boolean useSsl, boolean ignoreSslCert, String login, String password, Object ... extraArgs) throws LdapException {
        if (Strings.isNullOrEmpty((String)login) || Strings.isNullOrEmpty((String)password)) {
            throw new LdapException("LDAP login failed: empty login name or password");
        }
        Properties env = new Properties();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.referral", "follow");
        env.put("java.naming.provider.url", serverUrl);
        env.put("java.naming.security.authentication", method);
        env.put("java.naming.security.principal", login);
        env.put("java.naming.security.credentials", password);
        if (useSsl) {
            env.put("java.naming.security.protocol", "ssl");
            if (ignoreSslCert) {
                env.put("java.naming.ldap.factory.socket", EasySSLSocketFactory.class.getCanonicalName());
            }
        }
        InitialLdapContext ldapContext = null;
        try {
            ldapContext = new InitialLdapContext(env, null);
        }
        catch (NamingException e) {
            LOG.error((Object)e, (Throwable)e);
            throw new LdapException("LDAP login failure", (Throwable)e);
        }
        return ldapContext;
    }
}

