/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth.ldap.authentication;

import com.eucalyptus.auth.LdapException;
import com.eucalyptus.auth.crypto.StringCrypto;
import java.security.GeneralSecurityException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class AuthenticationUtil {
    public static final String CRYPTO_FORMAT = "RSA/ECB/PKCS1Padding";
    public static final String CRYPTO_PROVIDER = "BC";
    public static final Pattern ENCRYPTED_PATTERN = Pattern.compile("\\{(.+)\\}(.+)");
    private static final Logger LOG = Logger.getLogger(AuthenticationUtil.class);
    private static final StringCrypto CYPTO = new StringCrypto("RSA/ECB/PKCS1Padding", "BC");

    private static synchronized StringCrypto getCrypto() {
        return CYPTO;
    }

    public static String decryptPassword(String licCred) throws LdapException {
        try {
            Matcher matcher = ENCRYPTED_PATTERN.matcher(licCred);
            if (matcher.matches()) {
                return AuthenticationUtil.getCrypto().decryptOpenssl(matcher.group(1), matcher.group(2));
            }
            return licCred;
        }
        catch (GeneralSecurityException e) {
            LOG.error((Object)e, (Throwable)e);
            throw new LdapException("Decryption failure", (Throwable)e);
        }
    }
}

