/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth.ldap;

import com.eucalyptus.auth.ldap.Selection;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;

public class LdapIntegrationConfiguration {
    private String serverUrl;
    private String authMethod;
    private String userAuthMethod;
    private String authPrincipal;
    private String authCredentials;
    private boolean useSsl;
    private boolean ignoreSslCertValidation = false;
    private String krb5Conf;
    private boolean enableSync;
    private boolean autoSync;
    private long syncInterval;
    private boolean cleanDeletion;
    private boolean hasAccountingGroups;
    private String accountingGroupBaseDn;
    private String accountingGroupIdAttribute;
    private String groupsAttribute;
    private Selection accountingGroupsSelection = new Selection();
    private Map<String, Set<String>> groupsPartition = Maps.newHashMap();
    private String groupBaseDn;
    private String groupIdAttribute;
    private String usersAttribute;
    private String membersItemType;
    private Selection groupsSelection = new Selection();
    private String userBaseDn;
    private String userIdAttribute;
    private String userSaslIdAttribute;
    private Map<String, String> userInfoAttributes = Maps.newHashMap();
    private Selection usersSelection = new Selection();

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("---Parsed LIC---\n");
        sb.append("ldap-service:\n");
        sb.append('\t').append("server-url:").append(this.serverUrl).append('\n');
        sb.append('\t').append("auth-method:").append(this.authMethod).append('\n');
        sb.append('\t').append("user-auth-method:").append(this.userAuthMethod).append('\n');
        sb.append('\t').append("auth-principal:").append(this.authPrincipal).append('\n');
        sb.append('\t').append("auth-credentials:").append(this.authCredentials).append('\n');
        sb.append('\t').append("use-ssl:").append(this.useSsl).append('\n');
        sb.append('\t').append("ignore-ssl-cert-validation:").append(this.ignoreSslCertValidation).append('\n');
        sb.append('\t').append("krb5-conf:").append(this.krb5Conf).append('\n');
        sb.append("sync:\n");
        sb.append('\t').append("enable:").append(this.enableSync).append('\n');
        sb.append('\t').append("auto:").append(this.autoSync).append('\n');
        sb.append('\t').append("interval:").append(this.syncInterval).append('\n');
        sb.append('\t').append("clean-deletion:").append(this.cleanDeletion).append('\n');
        if (this.hasAccountingGroups) {
            sb.append("accounting-groups:\n");
            sb.append('\t').append("base-dn:").append(this.accountingGroupBaseDn).append('\n');
            sb.append('\t').append("id-attribute:").append(this.accountingGroupIdAttribute).append('\n');
            sb.append('\t').append("member-attribute:").append(this.groupsAttribute).append('\n');
            sb.append('\t').append("member-item-type:").append(this.membersItemType).append('\n');
            sb.append('\t').append("selection:").append(this.accountingGroupsSelection).append('\n');
        } else {
            sb.append("groups-partition:\n");
            sb.append('\t').append(this.groupsPartition).append('\n');
        }
        sb.append("groups:\n");
        sb.append('\t').append("base-dn:").append(this.groupBaseDn).append('\n');
        sb.append('\t').append("id-attribute:").append(this.groupIdAttribute).append('\n');
        sb.append('\t').append("member-attribute:").append(this.usersAttribute).append('\n');
        sb.append('\t').append("member-item-type:").append(this.membersItemType).append('\n');
        sb.append('\t').append("selection:").append(this.groupsSelection).append('\n');
        sb.append("users:\n");
        sb.append('\t').append("base-dn:").append(this.userBaseDn).append('\n');
        sb.append('\t').append("id-attribute:").append(this.userIdAttribute).append('\n');
        sb.append('\t').append("sasl-id-attribute:").append(this.userSaslIdAttribute).append('\n');
        sb.append('\t').append("user-info-attributes:").append(this.userInfoAttributes).append('\n');
        sb.append('\t').append("selection:").append(this.usersSelection).append('\n');
        return sb.toString();
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public void setAuthMethod(String authMethod) {
        this.authMethod = authMethod;
    }

    public String getAuthMethod() {
        return this.authMethod;
    }

    public void setAuthPrincipal(String authPrincipal) {
        this.authPrincipal = authPrincipal;
    }

    public String getAuthPrincipal() {
        return this.authPrincipal;
    }

    public void setUserBaseDn(String userBaseDn) {
        this.userBaseDn = userBaseDn;
    }

    public String getUserBaseDn() {
        return this.userBaseDn;
    }

    public void setGroupBaseDn(String groupBaseDn) {
        this.groupBaseDn = groupBaseDn;
    }

    public String getGroupBaseDn() {
        return this.groupBaseDn;
    }

    public void setHasAccountingGroups(boolean hasAccountingGroups) {
        this.hasAccountingGroups = hasAccountingGroups;
    }

    public boolean hasAccountingGroups() {
        return this.hasAccountingGroups;
    }

    public void setGroupsAttribute(String groupsAttribute) {
        this.groupsAttribute = groupsAttribute;
    }

    public String getGroupsAttribute() {
        return this.groupsAttribute;
    }

    public void setEnableSync(boolean enableSync) {
        this.enableSync = enableSync;
    }

    public boolean isSyncEnabled() {
        return this.enableSync;
    }

    public void setAutoSync(boolean autoSync) {
        this.autoSync = autoSync;
    }

    public boolean isAutoSync() {
        return this.autoSync;
    }

    public void setSyncInterval(long syncInterval) {
        this.syncInterval = syncInterval;
    }

    public long getSyncInterval() {
        return this.syncInterval;
    }

    public void setGroupsPartition(Map<String, Set<String>> groupsPartition) {
        this.groupsPartition = groupsPartition;
    }

    public Map<String, Set<String>> getGroupsPartition() {
        return this.groupsPartition;
    }

    public void setUserInfoAttributes(Map<String, String> userInfoAttributes) {
        this.userInfoAttributes = userInfoAttributes;
    }

    public Map<String, String> getUserInfoAttributes() {
        return this.userInfoAttributes;
    }

    public void setUsersAttribute(String usersAttribute) {
        this.usersAttribute = usersAttribute;
    }

    public String getUsersAttribute() {
        return this.usersAttribute;
    }

    public void setMembersItemType(String membersItemType) {
        this.membersItemType = membersItemType;
    }

    public String getMembersItemType() {
        return this.membersItemType;
    }

    public void setAccountingGroupIdAttribute(String accountingGroupIdAttribute) {
        this.accountingGroupIdAttribute = accountingGroupIdAttribute;
    }

    public String getAccountingGroupIdAttribute() {
        return this.accountingGroupIdAttribute;
    }

    public void setGroupIdAttribute(String groupIdAttribute) {
        this.groupIdAttribute = groupIdAttribute;
    }

    public String getGroupIdAttribute() {
        return this.groupIdAttribute;
    }

    public void setUserIdAttribute(String userIdAttribute) {
        this.userIdAttribute = userIdAttribute;
    }

    public String getUserIdAttribute() {
        return this.userIdAttribute;
    }

    public void setAuthCredentials(String authCredentials) {
        this.authCredentials = authCredentials;
    }

    public String getAuthCredentials() {
        return this.authCredentials;
    }

    public void setUseSsl(boolean useSsl) {
        this.useSsl = useSsl;
    }

    public boolean isUseSsl() {
        return this.useSsl;
    }

    public void setAccountingGroupBaseDn(String accountingGroupBaseDn) {
        this.accountingGroupBaseDn = accountingGroupBaseDn;
    }

    public String getAccountingGroupBaseDn() {
        return this.accountingGroupBaseDn;
    }

    public void setAccountingGroupsSelection(Selection accountingGroupsSelection) {
        this.accountingGroupsSelection = accountingGroupsSelection;
    }

    public Selection getAccountingGroupsSelection() {
        return this.accountingGroupsSelection;
    }

    public void setGroupsSelection(Selection groupsSelection) {
        this.groupsSelection = groupsSelection;
    }

    public Selection getGroupsSelection() {
        return this.groupsSelection;
    }

    public void setUsersSelection(Selection usersSeletion) {
        this.usersSelection = usersSeletion;
    }

    public Selection getUsersSelection() {
        return this.usersSelection;
    }

    public void setIgnoreSslCertValidation(boolean ignoreSslCertValidation) {
        this.ignoreSslCertValidation = ignoreSslCertValidation;
    }

    public boolean isIgnoreSslCertValidation() {
        return this.ignoreSslCertValidation;
    }

    public void setKrb5Conf(String krb5Conf) {
        this.krb5Conf = krb5Conf;
    }

    public String getKrb5Conf() {
        return this.krb5Conf;
    }

    public void setUserAuthMethod(String userAuthMethod) {
        this.userAuthMethod = userAuthMethod;
    }

    public String getUserAuthMethod() {
        return this.userAuthMethod;
    }

    public String getRealUserAuthMethod() {
        return this.userAuthMethod != null ? this.userAuthMethod : this.authMethod;
    }

    public void setCleanDeletion(boolean cleanDeletion) {
        this.cleanDeletion = cleanDeletion;
    }

    public boolean isCleanDeletion() {
        return this.cleanDeletion;
    }

    public String getUserSaslIdAttribute() {
        return this.userSaslIdAttribute;
    }

    public void setUserSaslIdAttribute(String userSaslIdAttribute) {
        this.userSaslIdAttribute = userSaslIdAttribute;
    }
}

