/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth.ldap;

import com.eucalyptus.auth.LdapException;
import com.eucalyptus.auth.ldap.LdapIntegrationConfiguration;
import com.eucalyptus.auth.ldap.authentication.AuthenticationUtil;
import com.eucalyptus.auth.ldap.authentication.LdapAuthenticatorFactory;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import org.apache.log4j.Logger;

public class LdapClient {
    public static final int TIMEOUT_IN_MILLIS = 60000;
    public static boolean DEBUG = false;
    private static Logger LOG = Logger.getLogger(LdapClient.class);
    private LdapContext context;

    private LdapClient() {
    }

    private LdapClient(LdapContext context) {
        this.context = context;
    }

    public static LdapClient authenticateClient(LdapIntegrationConfiguration lic) throws LdapException {
        LdapContext context = LdapAuthenticatorFactory.getLdapAuthenticator(lic.getAuthMethod()).authenticate(lic.getServerUrl(), lic.getAuthMethod(), lic.isUseSsl(), lic.isIgnoreSslCertValidation(), lic.getAuthPrincipal(), AuthenticationUtil.decryptPassword(lic.getAuthCredentials()), lic.getKrb5Conf());
        return new LdapClient(context);
    }

    public static LdapClient authenticateUser(LdapIntegrationConfiguration lic, String login, String password) throws LdapException {
        LdapContext context = LdapAuthenticatorFactory.getLdapAuthenticator(lic.getAuthMethod()).authenticate(lic.getServerUrl(), lic.getRealUserAuthMethod(), lic.isUseSsl(), lic.isIgnoreSslCertValidation(), login, password, lic.getKrb5Conf());
        return new LdapClient(context);
    }

    public void close() {
        if (this.context != null) {
            try {
                this.context.close();
            }
            catch (NamingException e) {
                LOG.error((Object)e, (Throwable)e);
            }
        }
    }

    public LdapContext getContext() {
        return this.context;
    }

    public synchronized NamingEnumeration<SearchResult> search(String baseDn, String filter, String[] attrs) throws LdapException {
        if (DEBUG) {
            LOG.debug((Object)("<search> " + baseDn + ": filter = " + filter));
        }
        SearchControls searchControls = new SearchControls();
        if (attrs != null) {
            searchControls.setReturningAttributes(attrs);
        }
        searchControls.setDerefLinkFlag(true);
        searchControls.setSearchScope(2);
        searchControls.setTimeLimit(60000);
        searchControls.setCountLimit(0L);
        try {
            return this.context.search(baseDn, filter, searchControls);
        }
        catch (NamingException e) {
            LOG.error((Object)e, (Throwable)e);
            throw new LdapException("Searching " + baseDn + "failed using " + filter, (Throwable)e);
        }
    }

    public synchronized NamingEnumeration<SearchResult> search(String baseDn, Attributes matchingAttrs, String[] attrs) throws LdapException {
        if (DEBUG) {
            LOG.debug((Object)("<search> " + baseDn + ": " + matchingAttrs));
        }
        try {
            return this.context.search(baseDn, matchingAttrs, attrs);
        }
        catch (NamingException e) {
            LOG.error((Object)e, (Throwable)e);
            throw new LdapException("Searching " + baseDn + "failed using " + matchingAttrs, (Throwable)e);
        }
    }
}

