/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth.json;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;

public class JsonUtils {
    public static String checkRequired(JSONObject map, String element) throws JSONException {
        if (!map.containsKey((Object)element)) {
            throw new JSONException("Missing required element " + element);
        }
        return element;
    }

    public static String checkBinaryOption(JSONObject map, String element1, String element2) throws JSONException {
        return JsonUtils.checkBinaryOption(map, element1, element2, true);
    }

    public static String checkBinaryOption(JSONObject map, String element1, String element2, boolean required) throws JSONException {
        boolean has1 = map.containsKey((Object)element1);
        boolean has2 = map.containsKey((Object)element2);
        if (required && !has1 && !has2) {
            throw new JSONException("Element " + element1 + " or " + element2 + " is required");
        }
        if (has1 && has2) {
            throw new JSONException("Element " + element1 + " and " + element2 + " can not be both present");
        }
        return has1 ? element1 : element2;
    }

    public static List<String> parseStringOrStringList(JSONObject statement, String key) throws JSONException {
        ArrayList results = Lists.newArrayList();
        try {
            String value = JsonUtils.getByType(String.class, statement, key);
            if (value != null) {
                results.add(value);
            }
            return results;
        }
        catch (JSONException value) {
            try {
                return JsonUtils.getArrayByType(String.class, statement, key);
            }
            catch (JSONException e) {
                throw new JSONException(key + " element can only be String or a list of String");
            }
        }
    }

    public static <T> List<T> getArrayByType(Class<T> type, JSONObject map, String key) throws JSONException {
        ArrayList results = Lists.newArrayList();
        JSONArray array = JsonUtils.getByType(JSONArray.class, map, key);
        if (array != null) {
            for (Object o : array) {
                if (o.getClass() == type) {
                    results.add(o);
                    continue;
                }
                throw new JSONException("Expecting array element type " + type.getName() + " but got " + o.getClass().getName());
            }
        }
        return results;
    }

    public static <T> T getByType(Class<T> type, JSONObject map, String key) throws JSONException {
        Object value = map.get(key);
        if (value == null) {
            return null;
        }
        if (value.getClass() != type) {
            throw new JSONException("Expecting " + type.getName() + " but got " + value.getClass().getName());
        }
        return (T)value;
    }

    public static <T> T getRequiredByType(Class<T> type, JSONObject map, String key) throws JSONException {
        T value = JsonUtils.getByType(type, map, key);
        if (value == null) {
            throw new JSONException("Expecting required element " + key);
        }
        return value;
    }

    public static <T> List<T> getRequiredArrayByType(Class<T> type, JSONObject map, String key) throws JSONException {
        List<T> results = JsonUtils.getArrayByType(type, map, key);
        if (results.size() < 1) {
            throw new JSONException("Expecting required element " + key);
        }
        return results;
    }
}

