/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth.entities;

import com.eucalyptus.auth.entities.AccessKeyEntity;
import com.eucalyptus.auth.entities.CertificateEntity;
import com.eucalyptus.auth.entities.GroupEntity;
import com.eucalyptus.auth.principal.User;
import com.eucalyptus.crypto.Crypto;
import com.eucalyptus.entities.AbstractPersistent;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.ManyToMany;
import javax.persistence.MapKeyColumn;
import javax.persistence.OneToMany;
import javax.persistence.PersistenceContext;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_auth")
@Table(name="auth_user")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class UserEntity
extends AbstractPersistent
implements Serializable {
    @Transient
    private static final long serialVersionUID = 1L;
    @Column(name="auth_user_id_external")
    String userId;
    @Column(name="auth_user_name")
    String name;
    @Column(name="auth_user_path")
    String path;
    @Enumerated(value=EnumType.STRING)
    @Column(name="auth_user_reg_stat")
    User.RegistrationStatus regStat;
    @Column(name="auth_user_is_enabled")
    Boolean enabled;
    @Column(name="auth_user_token")
    String token;
    @Column(name="auth_user_confirmation_code")
    String confirmationCode;
    @Column(name="auth_user_password")
    String password;
    @Column(name="auth_user_password_expires")
    Long passwordExpires;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="user")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    List<AccessKeyEntity> keys = Lists.newArrayList();
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="user")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    List<CertificateEntity> certificates = Lists.newArrayList();
    @ElementCollection
    @CollectionTable(name="auth_user_info_map")
    @MapKeyColumn(name="auth_user_info_key")
    @Column(name="auth_user_info_value")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    Map<String, String> info = Maps.newHashMap();
    @ManyToMany(fetch=FetchType.LAZY, mappedBy="users")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    List<GroupEntity> groups = Lists.newArrayList();

    public UserEntity() {
    }

    public UserEntity(String name) {
        this();
        this.name = name;
    }

    public UserEntity(Boolean enabled) {
        this();
        this.enabled = enabled;
    }

    @PrePersist
    public void generateOnCommit() {
        if (this.userId == null) {
            this.userId = Crypto.generateAlphanumericId((int)21, (String)"AID");
        }
    }

    public static UserEntity newInstanceWithUserId(String userId) {
        UserEntity u = new UserEntity();
        u.userId = userId;
        return u;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserEntity that = (UserEntity)o;
        return this.name.equals(that.name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("User(");
        sb.append("ID=").append(this.getId()).append(", ");
        sb.append("UserID=").append(this.getUserId()).append(", ");
        sb.append("name=").append(this.getName()).append(", ");
        sb.append("path=").append(this.getPath()).append(", ");
        sb.append("enabled=").append(this.isEnabled()).append(", ");
        sb.append("regStat=").append(this.getRegistrationStatus()).append(", ");
        sb.append("passwordExpires=").append(this.getPasswordExpires());
        sb.append(")");
        return sb.toString();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public User.RegistrationStatus getRegistrationStatus() {
        return this.regStat;
    }

    public void setRegistrationStatus(User.RegistrationStatus regStat) {
        this.regStat = regStat;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getConfirmationCode() {
        return this.confirmationCode;
    }

    public void setConfirmationCode(String confirmationCode) {
        this.confirmationCode = confirmationCode;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Long getPasswordExpires() {
        return this.passwordExpires;
    }

    public void setPasswordExpires(Long passwordExpires) {
        this.passwordExpires = passwordExpires;
    }

    public List<AccessKeyEntity> getKeys() {
        return this.keys;
    }

    public List<CertificateEntity> getCertificates() {
        return this.certificates;
    }

    public Map<String, String> getInfo() {
        return this.info;
    }

    public List<GroupEntity> getGroups() {
        return this.groups;
    }

    public String getUserId() {
        return this.userId;
    }
}

