/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth.entities;

import com.eucalyptus.auth.entities.AuthorizationEntity;
import com.eucalyptus.auth.entities.ConditionEntity;
import com.eucalyptus.auth.entities.PolicyEntity;
import com.eucalyptus.auth.entities.PrincipalEntity;
import com.eucalyptus.entities.AbstractPersistent;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_auth")
@Table(name="auth_statement")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class StatementEntity
extends AbstractPersistent
implements Serializable {
    @Transient
    private static final long serialVersionUID = 1L;
    @Column(name="auth_statement_sid")
    String sid;
    @OneToOne(cascade={CascadeType.ALL}, mappedBy="statement")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    PrincipalEntity principal;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="statement")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    List<AuthorizationEntity> authorizations;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="statement")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    List<ConditionEntity> conditions;
    @ManyToOne
    @JoinColumn(name="auth_statement_owning_policy")
    PolicyEntity policy;

    public StatementEntity() {
    }

    public StatementEntity(String sid) {
        this.sid = sid;
    }

    public StatementEntity(String sid, @Nullable PrincipalEntity principal, @Nonnull List<AuthorizationEntity> authorizations, @Nonnull List<ConditionEntity> conditions) {
        this.sid = sid;
        this.principal = principal;
        this.authorizations = authorizations;
        this.conditions = conditions;
        if (principal != null) {
            principal.setStatement(this);
        }
        for (AuthorizationEntity auth : authorizations) {
            auth.setStatement(this);
        }
        for (ConditionEntity cond : conditions) {
            cond.setStatement(this);
        }
    }

    public String getSid() {
        return this.sid;
    }

    public void setSid(String sid) {
        this.sid = sid;
    }

    public PrincipalEntity getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(PrincipalEntity principal) {
        this.principal = principal;
    }

    public List<AuthorizationEntity> getAuthorizations() {
        return this.authorizations;
    }

    public void setAuthorizations(List<AuthorizationEntity> authorizations) {
        this.authorizations = authorizations;
    }

    public List<ConditionEntity> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<ConditionEntity> conditions) {
        this.conditions = conditions;
    }

    public PolicyEntity getPolicy() {
        return this.policy;
    }

    public void setPolicy(PolicyEntity policy) {
        this.policy = policy;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ID=").append(this.getId()).append(", ");
        sb.append("sid=").append(this.getSid());
        return sb.toString();
    }

    public String getStatementId() {
        return this.getId();
    }
}

