/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth.entities;

import com.eucalyptus.auth.policy.PolicyResourceType;
import com.eucalyptus.component.annotation.PolicyVendor;
import com.eucalyptus.entities.AbstractOwnedPersistent;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.RestrictedType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Type;

@Entity
@PersistenceContext(name="eucalyptus_auth")
@Table(name="auth_server_cert")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
@PolicyVendor(value="iam")
@PolicyResourceType(value="server-certificate")
public class ServerCertificateEntity
extends AbstractOwnedPersistent
implements RestrictedType {
    @Transient
    private static final long serialVersionUID = 1L;
    @Column(name="metadata_server_cert_path", nullable=true)
    private String certificatePath;
    @Column(name="metadata_server_cert_id", nullable=true)
    private String certificateId;
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    @Column(name="metadata_server_cert_body", nullable=true)
    private String certificateBody;
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    @Column(name="metadata_server_cert_chain", nullable=true)
    private String certificateChain;
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    @Column(name="metadata_server_cert_pk", nullable=true)
    private String privateKey;
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    @Column(name="metadata_session_key", nullable=true)
    private String sessionKey;

    private ServerCertificateEntity() {
    }

    private ServerCertificateEntity(OwnerFullName user) {
        super(user, null);
    }

    public ServerCertificateEntity(OwnerFullName user, String certName) {
        super(user, certName);
    }

    public static ServerCertificateEntity named(OwnerFullName user) {
        return new ServerCertificateEntity(user);
    }

    public static ServerCertificateEntity named(OwnerFullName user, String certName) {
        ServerCertificateEntity entity = new ServerCertificateEntity(user, certName);
        entity.setUniqueName(entity.createUniqueName());
        return entity;
    }

    public void setCertName(String certName) {
        if (!ServerCertificateEntity.isCertificateNameValid(certName)) {
            throw new IllegalArgumentException();
        }
        this.setDisplayName(certName);
        this.setUniqueName(this.createUniqueName());
    }

    public String getCertName() {
        return this.displayName;
    }

    public String getCertPath() {
        return this.certificatePath;
    }

    public void setCertPath(String path) throws IllegalArgumentException {
        this.certificatePath = path == null ? "/" : path;
        if (!ServerCertificateEntity.isCertificatePathValid(this.certificatePath)) {
            throw new IllegalArgumentException();
        }
    }

    public void setCertBody(String body) {
        this.certificateBody = body;
    }

    public String getCertBody() {
        return this.certificateBody;
    }

    public void setCertChain(String chain) {
        this.certificateChain = chain;
    }

    public String getCertChain() {
        return this.certificateChain;
    }

    public void setPrivateKey(String pk) {
        this.privateKey = pk;
    }

    public void setSessionKey(String key) {
        this.sessionKey = key;
    }

    public String getSessionKey() {
        return this.sessionKey;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public void setCertId(String id) {
        this.certificateId = id;
    }

    public String getCertId() {
        return this.certificateId;
    }

    public static boolean isCertificatePathValid(String path) {
        if (path == null) {
            return false;
        }
        if (!path.startsWith("/")) {
            return false;
        }
        return path.length() >= 1 && path.length() <= 512;
    }

    public static boolean isCertificateNameValid(String name) {
        if (name == null) {
            return false;
        }
        if (!name.matches("[A-Za-z0-9\\+=,\\.@\\-]+")) {
            return false;
        }
        return name.length() >= 1 && name.length() <= 128;
    }
}

