/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth.entities;

import com.eucalyptus.auth.entities.AccountEntity;
import com.eucalyptus.auth.entities.InstanceProfileEntity;
import com.eucalyptus.auth.entities.PolicyEntity;
import com.eucalyptus.crypto.Crypto;
import com.eucalyptus.entities.AbstractPersistent;
import java.io.Serializable;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.PersistenceContext;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_auth")
@Table(name="auth_role")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class RoleEntity
extends AbstractPersistent
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Column(name="auth_role_id_external", nullable=false, updatable=false)
    private String roleId;
    @Column(name="auth_role_name", nullable=false)
    private String name;
    @Column(name="auth_role_path", nullable=false)
    private String path;
    @Column(name="auth_role_secret", nullable=false)
    private String secret;
    @OneToOne(cascade={CascadeType.ALL}, optional=false, orphanRemoval=true)
    @JoinColumn(name="auth_role_assume_role_policy_id", nullable=false)
    private PolicyEntity assumeRolePolicy;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="role")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private List<PolicyEntity> policies;
    @OneToMany(mappedBy="role")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private List<InstanceProfileEntity> instanceProfiles;
    @ManyToOne
    @JoinColumn(name="auth_role_owning_account", nullable=false)
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private AccountEntity account;
    @Column(name="auth_role_unique_name", unique=true, nullable=false)
    private String uniqueName;

    public RoleEntity() {
    }

    public RoleEntity(String name) {
        this();
        this.name = name;
    }

    public String getRoleId() {
        return this.roleId;
    }

    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public PolicyEntity getAssumeRolePolicy() {
        return this.assumeRolePolicy;
    }

    public void setAssumeRolePolicy(PolicyEntity assumeRolePolicy) {
        this.assumeRolePolicy = assumeRolePolicy;
    }

    public List<PolicyEntity> getPolicies() {
        return this.policies;
    }

    public void setPolicies(List<PolicyEntity> policies) {
        this.policies = policies;
    }

    public List<InstanceProfileEntity> getInstanceProfiles() {
        return this.instanceProfiles;
    }

    public void setInstanceProfiles(List<InstanceProfileEntity> instanceProfiles) {
        this.instanceProfiles = instanceProfiles;
    }

    public AccountEntity getAccount() {
        return this.account;
    }

    public void setAccount(AccountEntity account) {
        this.account = account;
    }

    @PrePersist
    @PreUpdate
    public void generateOnCommit() {
        if (this.roleId == null) {
            this.roleId = Crypto.generateAlphanumericId((int)21, (String)"ARO");
        }
        if (this.secret == null) {
            this.secret = Crypto.generateSecretKey();
        }
        this.uniqueName = this.account.getAccountNumber() + ":" + this.name;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Role(");
        sb.append("id=").append(this.getId()).append(", ");
        sb.append("roleId=").append(this.getRoleId()).append(", ");
        sb.append("name=").append(this.getName()).append(", ");
        sb.append("path=").append(this.getPath()).append(", ");
        sb.append(")");
        return sb.toString();
    }
}

