/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth.entities;

import com.eucalyptus.auth.entities.StatementEntity;
import com.eucalyptus.auth.principal.Principal;
import com.eucalyptus.entities.AbstractPersistent;
import java.io.Serializable;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_auth")
@Table(name="auth_principal")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class PrincipalEntity
extends AbstractPersistent
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Column(name="auth_principal_type", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private Principal.PrincipalType type;
    @ElementCollection
    @CollectionTable(name="auth_principal_value_list")
    @Column(name="auth_principal_value")
    private Set<String> values;
    @Column(name="auth_principal_not_principal", nullable=false)
    private Boolean notPrincipal;
    @ManyToOne
    @JoinColumn(name="auth_principal_owning_statement", nullable=false)
    private StatementEntity statement;

    public PrincipalEntity() {
    }

    public PrincipalEntity(@Nonnull Boolean notPrincipal, @Nonnull Principal.PrincipalType type, @Nonnull Set<String> values) {
        this.notPrincipal = notPrincipal;
        this.type = type;
        this.values = values;
    }

    public static PrincipalEntity newInstanceWithId(String id) {
        PrincipalEntity principalEntity = new PrincipalEntity();
        principalEntity.setId(id);
        return principalEntity;
    }

    public Principal.PrincipalType getType() {
        return this.type;
    }

    public void setType(Principal.PrincipalType type) {
        this.type = type;
    }

    public Set<String> getValues() {
        return this.values;
    }

    public void setValues(Set<String> values) {
        this.values = values;
    }

    public Boolean isNotPrincipal() {
        return this.notPrincipal;
    }

    public void setNotPrincipal(Boolean notPrincipal) {
        this.notPrincipal = notPrincipal;
    }

    public StatementEntity getStatement() {
        return this.statement;
    }

    public void setStatement(StatementEntity statement) {
        this.statement = statement;
    }

    public String getPrincipalId() {
        return this.getId();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Principal(");
        sb.append("ID=").append(this.getId()).append(", ");
        sb.append("type=").append(this.getType()).append(", ");
        sb.append("notPrincipal=").append(this.isNotPrincipal()).append(", ");
        sb.append("values=").append(this.getValues());
        sb.append(")");
        return sb.toString();
    }
}

