/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth.entities;

import com.eucalyptus.auth.entities.AuthorizationEntity;
import com.eucalyptus.auth.entities.GroupEntity;
import com.eucalyptus.auth.entities.RoleEntity;
import com.eucalyptus.auth.entities.StatementEntity;
import com.eucalyptus.auth.principal.Authorization;
import com.eucalyptus.entities.AbstractPersistent;
import java.io.Serializable;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Type;

@Entity
@PersistenceContext(name="eucalyptus_auth")
@Table(name="auth_policy")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class PolicyEntity
extends AbstractPersistent
implements Serializable {
    @Transient
    private static final long serialVersionUID = 1L;
    @Column(name="auth_policy_name")
    String name;
    @Column(name="auth_policy_version")
    String policyVersion;
    @Column(name="auth_policy_text")
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    String text;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="policy")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    List<StatementEntity> statements;
    @ManyToOne
    @JoinColumn(name="auth_policy_owning_group")
    GroupEntity group;
    @ManyToOne
    @JoinColumn(name="auth_policy_owning_role")
    RoleEntity role;

    public PolicyEntity() {
    }

    public PolicyEntity(String name) {
        this.name = name;
    }

    public PolicyEntity(String version, String text, List<StatementEntity> statements) {
        this.policyVersion = version;
        this.text = text;
        this.statements = statements;
        if (statements != null) {
            for (StatementEntity statement : statements) {
                statement.setPolicy(this);
            }
        }
    }

    public static PolicyEntity newInstanceWithId(String id) {
        PolicyEntity p = new PolicyEntity();
        p.setId(id);
        return p;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<StatementEntity> getStatements() {
        return this.statements;
    }

    public GroupEntity getGroup() {
        return this.group;
    }

    public void setGroup(GroupEntity group) {
        this.group = group;
    }

    public RoleEntity getRole() {
        return this.role;
    }

    public void setRole(RoleEntity role) {
        this.role = role;
    }

    public String getPolicyVersion() {
        return this.policyVersion;
    }

    public void setPolicyVersion(String policyVersion) {
        this.policyVersion = policyVersion;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ID=").append(this.getId()).append(", ");
        sb.append("name=").append(this.getName());
        return sb.toString();
    }

    public String getPolicyId() {
        return this.getId();
    }

    public boolean containsAllowEffect() {
        for (StatementEntity statement : this.getStatements()) {
            for (AuthorizationEntity authorization : statement.getAuthorizations()) {
                if (authorization.getEffect() != Authorization.EffectType.Allow) continue;
                return true;
            }
        }
        return false;
    }
}

