/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth.entities;

import com.eucalyptus.auth.entities.AccountEntity;
import com.eucalyptus.auth.entities.RoleEntity;
import com.eucalyptus.crypto.Crypto;
import com.eucalyptus.entities.AbstractPersistent;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PersistenceContext;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_auth")
@Table(name="auth_instance_profile")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class InstanceProfileEntity
extends AbstractPersistent
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Column(name="auth_instance_profile_id_external", nullable=false, updatable=false)
    private String instanceProfileId;
    @Column(name="auth_instance_profile_name", nullable=false)
    private String name;
    @Column(name="auth_instance_profile_path", nullable=false)
    private String path;
    @ManyToOne
    @JoinColumn(name="auth_instance_profile_role", nullable=true)
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private RoleEntity role;
    @ManyToOne
    @JoinColumn(name="auth_instance_profile_owning_account", nullable=false)
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private AccountEntity account;
    @Column(name="auth_instance_profile_unique_name", unique=true, nullable=false)
    private String uniqueName;

    public InstanceProfileEntity() {
    }

    public InstanceProfileEntity(String name) {
        this();
        this.name = name;
    }

    public String getInstanceProfileId() {
        return this.instanceProfileId;
    }

    public void setInstanceProfileId(String instanceProfileId) {
        this.instanceProfileId = instanceProfileId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public RoleEntity getRole() {
        return this.role;
    }

    public void setRole(RoleEntity role) {
        this.role = role;
    }

    public AccountEntity getAccount() {
        return this.account;
    }

    public void setAccount(AccountEntity account) {
        this.account = account;
    }

    @PrePersist
    @PreUpdate
    public void generateOnCommit() {
        if (this.instanceProfileId == null) {
            this.instanceProfileId = Crypto.generateAlphanumericId((int)21, (String)"AIP");
        }
        this.uniqueName = this.account.getAccountNumber() + ":" + this.name;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("InstanceProfile(");
        sb.append("id=").append(this.getId()).append(", ");
        sb.append("instanceProfileId=").append(this.getInstanceProfileId()).append(", ");
        sb.append("name=").append(this.getName()).append(", ");
        sb.append("path=").append(this.getPath()).append(", ");
        sb.append(")");
        return sb.toString();
    }
}

