/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth.entities;

import com.eucalyptus.auth.entities.AccountEntity;
import com.eucalyptus.auth.entities.PolicyEntity;
import com.eucalyptus.auth.entities.UserEntity;
import com.eucalyptus.crypto.Crypto;
import com.eucalyptus.entities.AbstractPersistent;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.PersistenceContext;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_auth")
@Table(name="auth_group")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class GroupEntity
extends AbstractPersistent
implements Serializable {
    @Transient
    private static final long serialVersionUID = 1L;
    @Column(name="auth_group_id_external")
    String groupId;
    @Column(name="auth_group_name")
    String name;
    @Column(name="auth_group_path")
    String path;
    @Column(name="auth_group_user_group")
    Boolean userGroup;
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="auth_group_has_users", joinColumns={@JoinColumn(name="auth_group_id")}, inverseJoinColumns={@JoinColumn(name="auth_user_id")})
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    List<UserEntity> users = Lists.newArrayList();
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="group")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    List<PolicyEntity> policies = Lists.newArrayList();
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="auth_group_owning_account")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    AccountEntity account;

    public GroupEntity() {
    }

    public GroupEntity(String name) {
        this();
        this.name = name;
    }

    public GroupEntity(Boolean userGroup) {
        this();
        this.userGroup = userGroup;
    }

    public static GroupEntity newInstanceWithGroupId(String id) {
        GroupEntity g = new GroupEntity();
        g.groupId = id;
        return g;
    }

    @PrePersist
    public void generateOnCommit() {
        if (this.groupId == null) {
            this.groupId = Crypto.generateAlphanumericId((int)21, (String)"AGP");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupEntity that = (GroupEntity)o;
        return this.name.equals(that.name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Group(");
        sb.append("ID=").append(this.getId()).append(", ");
        sb.append("name=").append(this.getName()).append(", ");
        sb.append("path=").append(this.getPath()).append(", ");
        sb.append("userGroup=").append(this.isUserGroup());
        sb.append(")");
        return sb.toString();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public AccountEntity getAccount() {
        return this.account;
    }

    public void setAccount(AccountEntity account) {
        this.account = account;
    }

    public Boolean isUserGroup() {
        return this.userGroup;
    }

    public void setUserGroup(Boolean userGroup) {
        this.userGroup = userGroup;
    }

    public List<PolicyEntity> getPolicies() {
        return this.policies;
    }

    public List<UserEntity> getUsers() {
        return this.users;
    }

    public String getGroupId() {
        return this.groupId;
    }
}

