/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth.entities;

import com.eucalyptus.auth.entities.UserEntity;
import com.eucalyptus.crypto.Crypto;
import com.eucalyptus.entities.AbstractPersistent;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.PersistenceContext;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Type;

@Entity
@PersistenceContext(name="eucalyptus_auth")
@Table(name="auth_cert")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class CertificateEntity
extends AbstractPersistent
implements Serializable {
    @Transient
    private static final long serialVersionUID = 1L;
    @Column(name="auth_certificate_active")
    Boolean active;
    @Column(name="auth_certificate_revoked")
    Boolean revoked;
    @Column(name="auth_certificate_id")
    String certificateId;
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    @Column(name="auth_certificate_pem")
    String pem;
    @Column(name="auth_certificate_create_date")
    Date createDate;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="auth_certificate_owning_user")
    UserEntity user;

    public CertificateEntity() {
    }

    public CertificateEntity(String pem) {
        this.pem = pem;
    }

    public static CertificateEntity newInstanceWithId(String id) {
        CertificateEntity c = new CertificateEntity();
        c.certificateId = id;
        return c;
    }

    @PrePersist
    public void generateOnCommit() {
        if (this.certificateId == null) {
            this.certificateId = Crypto.generateAlphanumericId((int)21, (String)"");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CertificateEntity that = (CertificateEntity)o;
        return this.getPem().equals(that.getPem());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Cert(");
        sb.append("ID=").append(this.getId()).append(", ");
        sb.append("active=").append(this.isActive()).append(", ");
        sb.append("revoked=").append(this.isRevoked()).append(", ");
        sb.append("pem=").append(this.getPem());
        sb.append(")");
        return sb.toString();
    }

    public String getPem() {
        return this.pem;
    }

    public void setPem(String pem) {
        this.pem = pem;
    }

    public Boolean isActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public Boolean isRevoked() {
        return this.revoked;
    }

    public void setRevoked(Boolean revoked) {
        this.revoked = revoked;
        if (this.revoked.booleanValue()) {
            this.active = false;
        }
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public UserEntity getUser() {
        return this.user;
    }

    public void setUser(UserEntity user) {
        this.user = user;
    }

    public String getCertificateId() {
        return this.certificateId;
    }
}

