/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth.entities;

import com.eucalyptus.auth.entities.StatementEntity;
import com.eucalyptus.auth.principal.Authorization;
import com.eucalyptus.entities.AbstractPersistent;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Set;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_auth")
@Table(name="auth_auth")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class AuthorizationEntity
extends AbstractPersistent
implements Serializable {
    @Transient
    private static final long serialVersionUID = 1L;
    @Enumerated(value=EnumType.STRING)
    @Column(name="auth_auth_effect")
    Authorization.EffectType effect;
    @Column(name="auth_auth_account")
    String account;
    @Column(name="auth_auth_type")
    String type;
    @Column(name="auth_auth_not_action")
    Boolean notAction;
    @ElementCollection
    @CollectionTable(name="auth_auth_action_list")
    @Column(name="auth_auth_actions")
    Set<String> actions;
    @Column(name="auth_auth_not_resource")
    Boolean notResource;
    @ElementCollection
    @CollectionTable(name="auth_auth_resource_list")
    @Column(name="auth_auth_resources")
    Set<String> resources;
    @ManyToOne
    @JoinColumn(name="auth_auth_owning_statement")
    StatementEntity statement;

    public AuthorizationEntity() {
    }

    public AuthorizationEntity(Authorization.EffectType effect, String account, String type, Set<String> actions, Boolean notAction, Set<String> resources, Boolean notResource) {
        this.effect = effect;
        this.account = account;
        this.type = type;
        this.notAction = notAction;
        this.actions = actions;
        this.notResource = notResource;
        this.resources = resources;
    }

    public AuthorizationEntity(Authorization.EffectType effect, Set<String> actions, Boolean notAction) {
        this.effect = effect;
        this.type = null;
        this.notAction = notAction;
        this.actions = actions;
        this.notResource = false;
        this.resources = Sets.newHashSet();
    }

    public AuthorizationEntity(String type) {
        this.type = type;
    }

    public static AuthorizationEntity newInstanceWithId(String id) {
        AuthorizationEntity a = new AuthorizationEntity();
        a.setId(id);
        return a;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Authorization(");
        sb.append("ID=").append(this.getId()).append(", ");
        sb.append("effect=").append(this.effect).append(", ");
        sb.append("account=").append(this.account).append(", ");
        sb.append("type=").append(this.type).append(", ");
        sb.append("notAction=").append(this.isNotAction()).append(", ");
        sb.append("notResource=").append(this.isNotResource());
        sb.append(")");
        return sb.toString();
    }

    public Authorization.EffectType getEffect() {
        return this.effect;
    }

    public void setEffect(Authorization.EffectType effect) {
        this.effect = effect;
    }

    public StatementEntity getStatement() {
        return this.statement;
    }

    public void setStatement(StatementEntity statement) {
        this.statement = statement;
    }

    public Boolean isNotAction() {
        return this.notAction;
    }

    public void setNotAction(Boolean notAction) {
        this.notAction = notAction;
    }

    public Boolean isNotResource() {
        return this.notResource;
    }

    public void setNotResource(Boolean notResource) {
        this.notResource = notResource;
    }

    public String getAccount() {
        return this.account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Set<String> getActions() {
        return this.actions;
    }

    public Set<String> getResources() {
        return this.resources;
    }

    public String getAuthorizationId() {
        return this.getId();
    }
}

