/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth.entities;

import com.eucalyptus.auth.Accounts;
import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.entities.GroupEntity;
import com.eucalyptus.component.id.Euare;
import com.eucalyptus.entities.AbstractPersistent;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.upgrade.Upgrades;
import com.eucalyptus.util.Exceptions;
import com.google.common.base.Predicate;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Nullable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityTransaction;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import javax.persistence.PersistenceContext;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_auth")
@Table(name="auth_account")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class AccountEntity
extends AbstractPersistent
implements Serializable {
    @Transient
    private static final long serialVersionUID = 1L;
    @Column(name="auth_account_name", unique=true)
    String name;
    @Column(name="auth_account_number", unique=true)
    String accountNumber;
    @Column(name="auth_account_canonical_id", length=64, unique=true)
    String canonicalId;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="account")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    List<GroupEntity> groups;

    public AccountEntity() {
    }

    public AccountEntity(String name) {
        this();
        this.name = name;
    }

    @PrePersist
    public void generateOnCommit() {
        this.accountNumber = String.format("%012d", (long)(Math.pow(10.0, 12.0) * Math.random()));
        this.populateCanonicalId();
    }

    public void populateCanonicalId() {
        if (this.canonicalId == null || "".equals(this.canonicalId)) {
            this.canonicalId = AccountEntity.genCanonicalId();
        }
    }

    private static String genCanonicalId() {
        StringBuilder buf = new StringBuilder();
        boolean notFinished = true;
        while (notFinished) {
            int rand = (int)(Math.pow(10.0, 4.0) * Math.random()) % 100;
            buf.append(Integer.toHexString(rand));
            int len = buf.length();
            if (len < 64) {
                notFinished = true;
            } else if (len == 64) {
                notFinished = false;
            } else {
                buf.delete(64, len + 1);
                notFinished = false;
            }
            if (notFinished) continue;
            try {
                Accounts.lookupAccountByCanonicalId((String)buf.toString());
                buf = new StringBuilder();
                notFinished = true;
            }
            catch (AuthException authException) {}
        }
        return buf.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountEntity that = (AccountEntity)o;
        return this.name.equals(that.name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Account(");
        sb.append("ID=").append(this.getId()).append(", ");
        sb.append("name=").append(this.getName()).append(", ");
        sb.append("canonical ID=").append(this.getCanonicalId());
        sb.append(")");
        return sb.toString();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public String getCanonicalId() {
        return this.canonicalId;
    }

    public void setCanonicalId(String canonicalId) {
        this.canonicalId = canonicalId;
    }

    public static AccountEntity newInstanceWithAccountNumber(String accountNumber) {
        AccountEntity a = new AccountEntity();
        a.setAccountNumber(accountNumber);
        return a;
    }

    @Upgrades.EntityUpgrade(entities={AccountEntity.class}, since=Upgrades.Version.v3_4_0, value=Euare.class)
    public static enum AccountEntityUpgrade implements Predicate<Class>
    {
        INSTANCE;

        private static Logger LOG;

        public boolean apply(@Nullable Class aClass) {
            EntityTransaction tran = Entities.get(AccountEntity.class);
            try {
                List accounts = Entities.query((Object)new AccountEntity());
                if (accounts != null && accounts.size() > 0) {
                    for (AccountEntity account : accounts) {
                        if (account.getCanonicalId() != null && !account.getCanonicalId().equals("")) continue;
                        account.setCanonicalId(AccountEntity.genCanonicalId());
                        LOG.debug((Object)("putting canonical id " + account.getCanonicalId() + " on account " + account.getAccountNumber()));
                    }
                }
                tran.commit();
            }
            catch (Exception ex) {
                tran.rollback();
                LOG.error((Object)"caught exception during upgrade, while attempting to generate and assign canonical ids");
                Exceptions.toUndeclared((Throwable)ex);
            }
            return true;
        }

        static {
            LOG = Logger.getLogger(AccountEntityUpgrade.class);
        }
    }
}

