/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth.entities;

import com.eucalyptus.auth.entities.UserEntity;
import com.eucalyptus.crypto.Crypto;
import com.eucalyptus.entities.AbstractPersistent;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PersistenceContext;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_auth")
@Table(name="auth_access_key")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class AccessKeyEntity
extends AbstractPersistent
implements Serializable {
    @Transient
    private static final long serialVersionUID = 1L;
    @Column(name="auth_access_key_active")
    Boolean active;
    @Column(name="auth_access_key_query_id")
    String accessKey;
    @Column(name="auth_access_key_key")
    String key;
    @Column(name="auth_access_key_create_date")
    Date createDate;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="auth_access_key_owning_user")
    UserEntity user;

    public AccessKeyEntity() {
    }

    public AccessKeyEntity(UserEntity user) {
        this.user = user;
        this.key = Crypto.generateSecretKey();
        this.createDate = new Date();
    }

    @PrePersist
    public void generateOnCommit() {
        if (this.accessKey == null && this.key != null) {
            this.accessKey = Crypto.generateAlphanumericId((int)20, (String)"AKI");
        }
    }

    public static AccessKeyEntity newInstanceWithAccessKeyId(String accessKeyId) {
        AccessKeyEntity k = new AccessKeyEntity();
        k.accessKey = accessKeyId;
        return k;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccessKeyEntity that = (AccessKeyEntity)o;
        if (!this.getAccessKey().equals(that.getAccessKey())) {
            return false;
        }
        return this.getSecretKey().equals(that.getSecretKey());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Key(");
        sb.append("ID=").append(this.getId()).append(", ");
        sb.append("active=").append(this.isActive()).append(", ");
        sb.append("key=").append(this.getSecretKey());
        sb.append(")");
        return sb.toString();
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccess(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.key;
    }

    public void setSecretKey(String key) {
        this.key = key;
    }

    public Boolean isActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public UserEntity getUser() {
        return this.user;
    }

    public void setUser(UserEntity user) {
        this.user = user;
    }
}

